/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.updatefield;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.ExprParser;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.UpdateFieldsRow;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CalcCompiler;

public class UpdateFieldDataSet
extends AbstractDataSet {
    private String[] exprs;
    private String[] fields;
    private Calc[] calcs;
    private Map<Integer, Integer> map;
    private Field[] newFields;

    public UpdateFieldDataSet(AbstractDataSet inner, String[] fields, String[] exprs) {
        this("UpdateField", inner, fields, exprs);
    }

    public UpdateFieldDataSet(String dataSetName, AbstractDataSet inner, String[] fields, String[] exprs) {
        super(dataSetName, inner);
        if (fields.length != exprs.length) {
            throw AlgoException.create("Params error: fields,exprs length must be same", new Object[0]);
        }
        this.fields = fields;
        this.exprs = exprs;
        this.init();
    }

    private void init() {
        RowMeta rowMeta = this.getInput(0).getRowMeta();
        ExprParser parser = new ExprParser(rowMeta);
        this.calcs = new Calc[this.exprs.length];
        this.newFields = new Field[this.exprs.length];
        Expr newExpr = null;
        for (int i = 0; i < this.exprs.length; ++i) {
            newExpr = parser.parse(this.exprs[i]);
            this.calcs[i] = CalcCompiler.compile(rowMeta, newExpr);
            DataType dataType = newExpr.getDataType();
            this.newFields[i] = new Field(this.fields[i], dataType);
        }
    }

    @Override
    protected RowMeta createTargetRowMeta() {
        RowMeta rowMeta = this.getInput(0).getRowMeta();
        Field[] fields = rowMeta.getFields();
        Field[] retFields = new Field[fields.length];
        DataType dataType = null;
        String alias = null;
        this.map = new HashMap<Integer, Integer>(this.fields.length);
        for (int i = 0; i < fields.length; ++i) {
            dataType = fields[i].getDataType();
            alias = fields[i].getAlias();
            for (int j = 0; j < this.newFields.length; ++j) {
                if (!this.newFields[j].getAlias().equals(alias)) continue;
                dataType = this.newFields[j].getDataType();
                this.map.put(i, j);
                break;
            }
            retFields[i] = new Field(alias, dataType);
        }
        return new RowMeta(retFields);
    }

    @Override
    protected InnerRowIterator createIterator() {
        this.checkClosed();
        return new MyIter();
    }

    @Override
    public void realClose() {
    }

    class MyIter
    extends InnerRowIterator {
        private Iterator<Row> inner;
        private RowMeta rowMeta;

        public MyIter() {
            this.inner = UpdateFieldDataSet.this.getInput(0).innerIterator();
            this.rowMeta = UpdateFieldDataSet.this.getRowMeta();
        }

        @Override
        public boolean _hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public Row _next() {
            Row innerRow = this.inner.next();
            return new UpdateFieldsRow(this.rowMeta, innerRow, UpdateFieldDataSet.this.calcs, UpdateFieldDataSet.this.map);
        }
    }
}

