/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.datatype;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AnyType
extends DataType {
    private static final long serialVersionUID = -636403529643846992L;
    public static final AnyType instance = new AnyType();

    private AnyType() {
        super(100, "Any");
    }

    @Override
    public int getFixedSize() {
        return -1;
    }

    @Override
    public boolean acceptsType(DataType other) {
        return true;
    }

    @Override
    public Class<?> getJavaType() {
        return Object.class;
    }

    @Override
    public void write(Object value, DataOutputStream output) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(output);
        oos.writeObject(value);
        oos.flush();
    }

    @Override
    public Object read(DataInputStream input) {
        try {
            ObjectInputStream ois = new ObjectInputStream(input);
            return ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new AlgoException(e);
        }
    }

    @Override
    public int getSqlType() {
        return 1111;
    }

    @Override
    public void write(Object value, DataOutput output) throws IOException {
        throw new AlgoException("Not supported type: " + this.getClass().getName());
    }

    @Override
    public Object read(DataInput input) throws IOException {
        throw new AlgoException("Not supported type: " + this.getClass().getName());
    }
}

