/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.datatype;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import kd.bos.algo.datatype.FractionalType;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BigDecimalType
extends FractionalType {
    private static final long serialVersionUID = 4626196577863060845L;
    private int precision = 23;
    private int scale = 10;

    public BigDecimalType() {
        super(5, "BigDecimal");
    }

    @Override
    public int getFixedSize() {
        return 0;
    }

    @Override
    public int guessHeapSize(Object value) {
        if (value == null) {
            return 4;
        }
        return 50;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public Class<?> getJavaType() {
        return BigDecimal.class;
    }

    @Override
    protected int getCompatibleLevel() {
        return 4;
    }

    @Override
    public void write(Object value, DataOutput target) throws IOException {
        if (value == null) {
            kd.bos.algo.datatype.BigDecimalType.writeBigInteger(null, target);
            return;
        }
        if (value == BigDecimal.ZERO) {
            kd.bos.algo.datatype.BigDecimalType.writeBigInteger(BigInteger.ZERO, target);
            target.writeInt(0);
            return;
        }
        if (value == BigDecimal.ONE) {
            kd.bos.algo.datatype.BigDecimalType.writeBigInteger(BigInteger.ONE, target);
            target.writeInt(0);
            return;
        }
        if (value == BigDecimal.TEN) {
            kd.bos.algo.datatype.BigDecimalType.writeBigInteger(BigInteger.TEN, target);
            target.writeInt(0);
            return;
        }
        BigDecimal bd = (BigDecimal)value;
        kd.bos.algo.datatype.BigDecimalType.writeBigInteger(bd.unscaledValue(), target);
        target.writeInt(bd.scale());
    }

    @Override
    public Object read(DataInput source) throws IOException {
        BigInteger unscaledValue = kd.bos.algo.datatype.BigDecimalType.readBigInteger(source);
        if (unscaledValue == null) {
            return null;
        }
        int scale = source.readInt();
        if (scale == 0) {
            if (unscaledValue == BigInteger.ZERO) {
                return BigDecimal.ZERO;
            }
            if (unscaledValue == BigInteger.ONE) {
                return BigDecimal.ONE;
            }
            if (unscaledValue == BigInteger.TEN) {
                return BigDecimal.TEN;
            }
        }
        return new BigDecimal(unscaledValue, scale);
    }

    public static void writeBigInteger(BigInteger value, DataOutput target) throws IOException {
        if (value == null) {
            target.writeInt(0);
            return;
        }
        if (value == BigInteger.ZERO) {
            target.writeInt(1);
            return;
        }
        if (value == BigInteger.ONE) {
            target.writeInt(2);
            return;
        }
        if (value == BigInteger.TEN) {
            target.writeInt(3);
            return;
        }
        byte[] bytes = value.toByteArray();
        target.writeInt(bytes.length + 4);
        target.write(bytes);
    }

    public static BigInteger readBigInteger(DataInput source) throws IOException {
        int len = source.readInt();
        if (len < 4) {
            switch (len) {
                case 0: {
                    return null;
                }
                case 1: {
                    return BigInteger.ZERO;
                }
                case 2: {
                    return BigInteger.ONE;
                }
                case 3: {
                    return BigInteger.TEN;
                }
            }
        }
        byte[] bytes = new byte[len - 4];
        source.readFully(bytes);
        return new BigInteger(bytes);
    }

    @Override
    public void write(Object value, DataOutputStream output) throws IOException {
        this.write(value, (DataOutput)output);
    }

    @Override
    public Object read(DataInputStream input) throws IOException {
        return this.read((DataInput)input);
    }
}

