/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.datatype;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.AnyType;
import kd.bos.algo.datatype.NullType;
import kd.bos.algo.datatype.UnknownType;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BooleanType
extends DataType {
    private static final long serialVersionUID = -2623188676007400270L;

    public BooleanType() {
        super(0, "Boolean");
    }

    @Override
    public int getFixedSize() {
        return 1;
    }

    @Override
    public boolean acceptsType(DataType other) {
        if (other instanceof NullType || other instanceof AnyType || other instanceof UnknownType) {
            return true;
        }
        return other instanceof BooleanType;
    }

    @Override
    public Class<?> getJavaType() {
        return Boolean.class;
    }

    @Override
    public void write(Object value, DataOutputStream output) throws IOException {
        output.writeBoolean((Boolean)value);
    }

    @Override
    public Object read(DataInputStream input) throws IOException {
        return input.readBoolean();
    }

    @Override
    public void write(Object value, DataOutput output) throws IOException {
        output.writeBoolean((Boolean)value);
    }

    @Override
    public Object read(DataInput input) throws IOException {
        return input.readBoolean();
    }

    @Override
    public int getSqlType() {
        return 16;
    }
}

