/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.datatype;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.AnyType;
import kd.bos.algo.datatype.NullType;
import kd.bos.algo.datatype.TimestampType;
import kd.bos.algo.datatype.UnknownType;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DateType
extends DataType {
    private static final long serialVersionUID = -5288130924388411956L;

    public DateType() {
        super(6, "Date");
    }

    @Override
    public int getFixedSize() {
        return 8;
    }

    @Override
    public boolean acceptsType(DataType other) {
        if (other instanceof NullType || other instanceof AnyType || other instanceof UnknownType) {
            return true;
        }
        return other instanceof TimestampType || other instanceof DateType;
    }

    @Override
    public Class<?> getJavaType() {
        return Date.class;
    }

    @Override
    public void write(Object value, DataOutputStream dos) throws IOException {
        dos.writeLong(((Date)value).getTime());
    }

    @Override
    public Object read(DataInputStream dis) throws IOException {
        long time = dis.readLong();
        return new Date(time);
    }

    @Override
    public void write(Object value, DataOutput dos) throws IOException {
        dos.writeLong(((Date)value).getTime());
    }

    @Override
    public Object read(DataInput dis) throws IOException {
        long time = dis.readLong();
        return new Date(time);
    }

    @Override
    public int getSqlType() {
        return 91;
    }
}

