/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.datatype;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.AnyType;
import kd.bos.algo.datatype.NullType;
import kd.bos.algo.util.types.StringSerializer;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class StringType
extends DataType {
    private static final long serialVersionUID = -7906379051663118840L;

    public StringType() {
        super(1, "String");
    }

    @Override
    public int getFixedSize() {
        return 0;
    }

    @Override
    public boolean acceptsType(DataType other) {
        if (other instanceof NullType || other instanceof AnyType) {
            return true;
        }
        return other instanceof StringType;
    }

    @Override
    public Class<?> getJavaType() {
        return String.class;
    }

    @Override
    public int guessHeapSize(Object value) {
        if (value == null) {
            return 4;
        }
        String str = (String)value;
        int div = str.length() * 2 / 8;
        int mod = str.length() * 2 % 8;
        if (mod > 0) {
            ++div;
        }
        return 24 + div * 8;
    }

    @Override
    public void write(Object value, DataOutputStream output) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(output);
        oos.writeObject(value);
    }

    @Override
    public Object read(DataInputStream input) throws IOException {
        ObjectInputStream ois = new ObjectInputStream(input);
        try {
            return ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int getSqlType() {
        return 12;
    }

    @Override
    public void write(Object value, DataOutput output) throws IOException {
        StringSerializer.writeString((String)value, output);
    }

    @Override
    public Object read(DataInput input) throws IOException {
        return StringSerializer.readString(input);
    }
}

