/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.env;

import java.io.Closeable;
import java.util.ArrayList;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoConfig;
import kd.bos.algo.DataSet;
import kd.bos.algo.HashTable;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.env.ThreadContext;

public abstract class Environment
extends Algo
implements Closeable,
AutoCloseable {
    private AlgoConfig config;
    private ArrayList<Listener> listeners = new ArrayList();

    public Environment(AlgoConfig config) {
        this.config = config;
        ThreadContext.addEnvironment(this);
    }

    public AlgoConfig getConfig() {
        return this.config;
    }

    public abstract HashTable toHashTable(AbstractDataSet var1, String var2);

    public abstract void registerDataSet(DataSet var1);

    public abstract void unregisterDataSet(DataSet var1);

    @Override
    public abstract void close();

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public void fireClosed() {
        for (Listener l : this.listeners) {
            l.closed();
        }
    }

    protected abstract int getDataSetSize();

    public static interface Listener {
        public void closed();
    }
}

