/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.env.jvm;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.AlgoConfig;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.HashTable;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.builder.StoreDataSetBuilder;
import kd.bos.algo.dataset.cache.CachedDataSetBuilder;
import kd.bos.algo.dataset.hashjoin.HashTableFactory;
import kd.bos.algo.dataset.input.InputDataSet;
import kd.bos.algo.dataset.streamsource.CollectionDataSet;
import kd.bos.algo.dataset.streamsource.IteratorDataSet;
import kd.bos.algo.dataset.streamsource.ResultSetDataSet;
import kd.bos.algo.env.Environment;
import kd.bos.algo.env.ThreadContext;
import kd.bos.algo.exception.AlgoExceedAllowMaxDataSetsException;
import kd.bos.algo.util.resource.ResourceHolder;
import kd.bos.monitor.sdk.KDGauge;
import kd.bos.monitor.sdk.ScheduledCollector;
import kd.bos.util.ThreadLocals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmEnvironment
extends Environment {
    private static Logger logger = LoggerFactory.getLogger(JvmEnvironment.class);
    private HashSet<AbstractDataSet> dataSets = new HashSet();
    private HashSet<HashTable> hashtables = new HashSet();
    private final AtomicInteger threadDataSetCount = thDataSetCount.get();
    private static final ThreadLocal<AtomicInteger> thDataSetCount = ThreadLocals.create(() -> new AtomicInteger());
    private static final AtomicInteger allDataSetCount = new AtomicInteger(0);
    private static final KDGauge GAUGE = KDGauge.build((String)"datasetCount", (String)"dataset count");

    public JvmEnvironment(AlgoConfig config) {
        super(config);
    }

    @Override
    public DataSet createDataSet(Collection<Object[]> rowList, RowMeta rowMeta) {
        return new CollectionDataSet(this, rowList, rowMeta);
    }

    @Override
    public DataSet createDataSet(Iterable<Object[]> iterable, RowMeta rowMeta) {
        return new IteratorDataSet(this, iterable.iterator(), rowMeta);
    }

    @Override
    public DataSet createDataSet(Iterator<Object[]> iterator, RowMeta rowMeta) {
        return new IteratorDataSet(this, iterator, rowMeta);
    }

    @Override
    public DataSet createDataSet(ResultSet rs) {
        return new ResultSetDataSet(this, rs);
    }

    @Override
    public DataSet createDataSet(ResultSet rs, RowMeta rowMeta) {
        return new ResultSetDataSet(this, rs, rowMeta);
    }

    @Override
    public DataSet createDataSet(Input ... inputs) {
        if (inputs.length == 0) {
            throw new IllegalArgumentException("Illegal input length 0");
        }
        InputDataSet dataSet = new InputDataSet(this, inputs);
        return dataSet;
    }

    @Override
    public DataSetBuilder createDataSetBuilder(RowMeta rowMeta) {
        return new StoreDataSetBuilder(this, rowMeta);
    }

    @Override
    public void execute() {
    }

    @Override
    public HashTable toHashTable(AbstractDataSet dataSet, String keyField) {
        RowMeta rowMeta = dataSet.getRowMeta();
        int index = rowMeta.getFieldIndex(keyField);
        return HashTableFactory.createHashTable(dataSet, index);
    }

    @Override
    public void close() {
        this.autoRelease();
    }

    private void autoRelease() {
        for (HashTable h : this.hashtables) {
            h.close();
        }
        ArrayList<AbstractDataSet> toCloseDataSets = new ArrayList<AbstractDataSet>();
        toCloseDataSets.addAll(this.dataSets);
        for (AbstractDataSet dataSet : toCloseDataSets) {
            if (dataSet.getOutputCount() != 0) continue;
            dataSet.close();
        }
        for (HashTable h : this.hashtables) {
            if (!(h instanceof ResourceHolder)) continue;
            ((ResourceHolder)((Object)h)).closeAllResources();
        }
        for (AbstractDataSet dataSet : toCloseDataSets) {
            dataSet.closeAllResources();
        }
        for (HashTable h : this.hashtables) {
            if (!(h instanceof ResourceHolder)) continue;
            ((ResourceHolder)((Object)h)).closeAllSubResources();
        }
        for (AbstractDataSet dataSet : toCloseDataSets) {
            dataSet.closeAllSubResources();
        }
        this.fireClosed();
        this.checkAllClosed(toCloseDataSets);
    }

    private void checkAllClosed(ArrayList<AbstractDataSet> toCloseDataSets) {
        for (AbstractDataSet dataset : toCloseDataSets) {
            if (dataset.isClosed()) continue;
            dataset.forceClose();
        }
    }

    @Override
    public void registerDataSet(DataSet dataSet) {
        this.incrDataSetCount();
        this.dataSets.add((AbstractDataSet)dataSet);
    }

    @Override
    public void unregisterDataSet(DataSet dataSet) {
        if (this.dataSets.remove((AbstractDataSet)dataSet)) {
            this.decrDataSetCount();
        }
    }

    @Override
    public CachedDataSet.Builder createCachedDataSetBuilder(RowMeta rowMeta, CacheHint hint) {
        return new CachedDataSetBuilder(rowMeta, hint, null);
    }

    private void incrDataSetCount() {
        allDataSetCount.addAndGet(1);
        int threadCount = this.threadDataSetCount.addAndGet(1);
        int threadMaxDataSetCount = AlgoConfiguration.THREAD_MAX_DATASETCOUNT.getInt();
        if (threadCount > threadMaxDataSetCount) {
            Map<String, Integer> currentThreadDataSetSize = ThreadContext.getCurrentThreadDataSetSize();
            throw new AlgoExceedAllowMaxDataSetsException("Exceed dataset count limit per thread: " + threadMaxDataSetCount + ", please close dataset as soon as possible.The size of DataSet for each AlgoKey : " + currentThreadDataSetSize, threadCount, threadMaxDataSetCount);
        }
    }

    private void decrDataSetCount() {
        int allCount = allDataSetCount.addAndGet(-1);
        int threadCount = this.threadDataSetCount.addAndGet(-1);
        if (threadCount < 0) {
            this.threadDataSetCount.set(0);
            logger.warn("current thread dataset count:[" + threadCount + "]!");
        }
        if (allCount < 0) {
            allDataSetCount.set(0);
            logger.warn("all thread dataset count:[" + allCount + "]");
        }
    }

    @Override
    protected int getDataSetSize() {
        return this.dataSets.size();
    }

    static {
        ScheduledCollector.registerHandler((String)JvmEnvironment.class.getName(), () -> GAUGE.set((double)allDataSetCount.get()));
    }
}

