/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.interpret;

import java.util.Date;
import kd.bos.algo.AlgoException;
import kd.bos.algo.sql.tree.Expr;

public final class ExplicitCheck {
    public static Object checkNotNull(Object value, String errorMessage, Expr expr) {
        if (value == null) {
            throw ExplicitCheck.wrapException(errorMessage, expr);
        }
        return value;
    }

    public static String checkString(Object value, String errorMessage, Expr expr) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw ExplicitCheck.wrapException(String.format(errorMessage, value.toString()), expr);
    }

    public static Number checkNumber(Object value, String errorMessage, Expr expr) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Number)) {
            throw ExplicitCheck.wrapException(String.format(errorMessage, value.toString()), expr);
        }
        return (Number)value;
    }

    public static Date checkDate(Object value, String errorMessage, Expr expr) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Date)) {
            throw ExplicitCheck.wrapException(String.format(errorMessage, value.toString()), expr);
        }
        return (Date)value;
    }

    public static Boolean checkBoolean(Object value, String errorMessage, Expr expr) {
        return ExplicitCheck.checkType(value, Boolean.class, errorMessage, expr);
    }

    public static <T> T checkType(Object value, Class<T> clazz, String errorMessage, Expr expr) {
        if (value == null) {
            return null;
        }
        if (clazz.isInstance(value)) {
            return (T)value;
        }
        throw ExplicitCheck.wrapException(String.format(errorMessage, value.toString()), expr);
    }

    public static Integer checkInteger(Object value, String errorMessage, Expr expr) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Integer)) {
            throw ExplicitCheck.wrapException(String.format(errorMessage, value.toString()), expr);
        }
        return (Integer)value;
    }

    private static AlgoException wrapException(String message, Expr expr) {
        if (expr != null && expr.getLocation().isPresent()) {
            message = message + ",expression:" + expr.getLocation().get().getText();
        }
        return new AlgoException(message);
    }
}

