/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.parser;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.AnyType;
import kd.bos.algo.sql.g.GBaseVisitor;
import kd.bos.algo.sql.g.GParser;
import kd.bos.algo.sql.tree.Add;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.AliasedRelation;
import kd.bos.algo.sql.tree.AllColumns;
import kd.bos.algo.sql.tree.And;
import kd.bos.algo.sql.tree.CaseWhenClause;
import kd.bos.algo.sql.tree.CaseWhenSearch;
import kd.bos.algo.sql.tree.CaseWhenSimple;
import kd.bos.algo.sql.tree.Cast;
import kd.bos.algo.sql.tree.Divide;
import kd.bos.algo.sql.tree.Equal;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.ExprList;
import kd.bos.algo.sql.tree.GT;
import kd.bos.algo.sql.tree.GTE;
import kd.bos.algo.sql.tree.GroupBy;
import kd.bos.algo.sql.tree.GroupingElement;
import kd.bos.algo.sql.tree.In;
import kd.bos.algo.sql.tree.IsNotNull;
import kd.bos.algo.sql.tree.IsNull;
import kd.bos.algo.sql.tree.Join;
import kd.bos.algo.sql.tree.JoinOn;
import kd.bos.algo.sql.tree.LT;
import kd.bos.algo.sql.tree.LTE;
import kd.bos.algo.sql.tree.Like;
import kd.bos.algo.sql.tree.Limit;
import kd.bos.algo.sql.tree.Literal;
import kd.bos.algo.sql.tree.Multiply;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.Not;
import kd.bos.algo.sql.tree.NotEqual;
import kd.bos.algo.sql.tree.Or;
import kd.bos.algo.sql.tree.OrderBy;
import kd.bos.algo.sql.tree.Parameter;
import kd.bos.algo.sql.tree.QualifiedName;
import kd.bos.algo.sql.tree.Query;
import kd.bos.algo.sql.tree.QueryBody;
import kd.bos.algo.sql.tree.QuerySpecification;
import kd.bos.algo.sql.tree.Relation;
import kd.bos.algo.sql.tree.Remainder;
import kd.bos.algo.sql.tree.Select;
import kd.bos.algo.sql.tree.SelectItem;
import kd.bos.algo.sql.tree.SimpleGroupBy;
import kd.bos.algo.sql.tree.SingleColumn;
import kd.bos.algo.sql.tree.SortDirect;
import kd.bos.algo.sql.tree.SortItem;
import kd.bos.algo.sql.tree.SortOrder;
import kd.bos.algo.sql.tree.StringAdd;
import kd.bos.algo.sql.tree.Substract;
import kd.bos.algo.sql.tree.Table;
import kd.bos.algo.sql.tree.UnaryMinus;
import kd.bos.algo.sql.tree.Union;
import kd.bos.algo.sql.tree.UnresolvedAttribute;
import kd.bos.algo.sql.tree.UnresolvedExtractValue;
import kd.bos.algo.sql.tree.UnresolvedFuncall;
import kd.bos.algo.sql.tree.UnresolvedStar;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ASTBuilder
extends GBaseVisitor<Object> {
    private String originText;
    private int parameterPosition;

    public ASTBuilder(String originText) {
        this.originText = originText;
    }

    private Optional<NodeLocation> getLocation(TerminalNode terminalNode) {
        Objects.requireNonNull(terminalNode, "terminalNode is null");
        String text = terminalNode.getText();
        NodeLocation location = new NodeLocation(text);
        return Optional.of(location);
    }

    private Optional<NodeLocation> getLocation(ParserRuleContext parserRuleContext) {
        Objects.requireNonNull(parserRuleContext, "parserRuleContext is null");
        NodeLocation location = new NodeLocation(this.originText, parserRuleContext.getStart().getStartIndex(), parserRuleContext.getStop().getStopIndex() + 1 - parserRuleContext.getStart().getStartIndex());
        return Optional.of(location);
    }

    @Override
    public Expr visitNamedExpression(GParser.NamedExpressionContext ctx) {
        Expr e = (Expr)this.visitExpression(ctx.expression());
        if (ctx.identifier() != null) {
            return new Alias(this.getLocation(ctx), e, ctx.identifier().getText());
        }
        if (ctx.qualifiedName() != null) {
            return new Alias(this.getLocation(ctx), e, ctx.qualifiedName().getText());
        }
        return e;
    }

    @Override
    public Object visitQuery(GParser.QueryContext ctx) {
        QueryBody body = (QueryBody)this.visit((ParseTree)ctx.queryNoWith());
        return new Query(this.getLocation(ctx), body);
    }

    private static Optional<String> getTextIfPresent(Token token) {
        return Optional.ofNullable(token).map(Token::getText);
    }

    private <T> Optional<T> visitIfPresent(ParserRuleContext ctx, Class<T> clazz) {
        return Optional.ofNullable(ctx).map(this::visit).map(clazz::cast);
    }

    private <T> List<T> visit(List<? extends ParserRuleContext> contexts, Class<T> clazz) {
        return contexts.stream().map(this::visit).map(clazz::cast).collect(Collectors.toList());
    }

    @Override
    public Object visitSingleInsertQuery(GParser.SingleInsertQueryContext ctx) {
        List<TerminalNode> integerValues;
        QueryBody queryBody = (QueryBody)this.visit((ParseTree)ctx.queryTerm());
        Optional<OrderBy> orderBy = Optional.empty();
        if (!ctx.queryOrganization().order.isEmpty()) {
            List<SortItem> sortList = ctx.queryOrganization().order.stream().map(this::visitSortItem2).collect(Collectors.toList());
            orderBy = Optional.of(new OrderBy(this.getLocation(ctx.queryOrganization()), sortList));
        }
        Optional<Limit> limit = Optional.empty();
        if (ctx.queryOrganization().limit != null && (integerValues = ctx.queryOrganization().INTEGER_VALUE()) != null && integerValues.size() > 0) {
            int int1 = Integer.parseInt(integerValues.get(0).getText());
            if (integerValues.size() > 1) {
                int int2 = Integer.parseInt(integerValues.get(1).getText());
                limit = Optional.of(new Limit(int1, int2));
            } else {
                limit = Optional.of(new Limit(int1));
            }
        }
        if (queryBody instanceof QuerySpecification) {
            QuerySpecification spec = (QuerySpecification)queryBody;
            return new QuerySpecification(spec.getLocation(), spec.getSelect(), spec.getFrom(), spec.getWhere(), spec.getGroupBy(), spec.getHaving(), orderBy, limit);
        }
        return queryBody;
    }

    @Override
    public Object visitQueryOrganization(GParser.QueryOrganizationContext ctx) {
        return null;
    }

    @Override
    public Object visitQueryTermDefault(GParser.QueryTermDefaultContext ctx) {
        return super.visitQueryTermDefault(ctx);
    }

    @Override
    public Object visitSetOperation(GParser.SetOperationContext ctx) {
        QueryBody left = (QueryBody)this.visit((ParseTree)ctx.left);
        QueryBody right = (QueryBody)this.visit((ParseTree)ctx.right);
        boolean distinct = ctx.setQuantifier() != null && ctx.setQuantifier().DISTINCT() != null;
        switch (ctx.operator.getType()) {
            case 41: {
                return new Union(this.getLocation(ctx.UNION()), (List<Relation>)ImmutableList.of((Object)left, (Object)right), distinct);
            }
        }
        throw new IllegalArgumentException("Unsupported set operation: " + ctx.operator.getText());
    }

    @Override
    public Object visitQueryPrimaryDefault(GParser.QueryPrimaryDefaultContext ctx) {
        return super.visitQueryPrimaryDefault(ctx);
    }

    @Override
    public Object visitSortItem(GParser.SortItemContext ctx) {
        SortDirect direct = ctx.DESC() != null ? SortDirect.DESC : SortDirect.ASC;
        return new SortOrder(this.getLocation(ctx), this.expression(ctx.expression()), direct);
    }

    private SortItem visitSortItem2(GParser.SortItemContext ctx) {
        return new SortItem(this.getLocation(ctx), (Expr)this.visit((ParseTree)ctx.expression()), Optional.ofNullable(ctx.ordering).map(ASTBuilder::getOrderingType).orElse(SortItem.Ordering.ASCENDING));
    }

    private static SortItem.Ordering getOrderingType(Token token) {
        switch (token.getType()) {
            case 25: {
                return SortItem.Ordering.ASCENDING;
            }
            case 26: {
                return SortItem.Ordering.DESCENDING;
            }
        }
        throw new IllegalArgumentException("Unsupported ordering: " + token.getText());
    }

    private static boolean isDistinct(GParser.SetQuantifierContext setQuantifier) {
        return setQuantifier != null && setQuantifier.DISTINCT() != null;
    }

    @Override
    public Object visitQuerySpecification(GParser.QuerySpecificationContext ctx) {
        List relations;
        Optional<Relation> from = Optional.empty();
        List<SelectItem> selectItems = this.visitSelect(ctx.namedExpressionSeq());
        if (ctx.fromClause() != null && !(relations = (List)this.visitFromClause(ctx.fromClause())).isEmpty()) {
            Iterator iterator = relations.iterator();
            Relation relation = (Relation)iterator.next();
            while (iterator.hasNext()) {
                relation = new Join(this.getLocation(ctx), Join.Type.IMPLICIT, relation, (Relation)iterator.next(), Optional.empty());
            }
            from = Optional.of(relation);
        }
        return new QuerySpecification(this.getLocation(ctx), new Select(this.getLocation(ctx.SELECT()), ASTBuilder.isDistinct(ctx.setQuantifier()), selectItems), from, this.visitIfPresent(ctx.where, Expr.class), this.visitIfPresent(ctx.aggregation(), GroupBy.class), this.visitIfPresent(ctx.having, Expr.class), Optional.empty(), Optional.empty());
    }

    @Override
    public Object visitFromClause(GParser.FromClauseContext ctx) {
        return ctx.relation().stream().map(this::visit).map(Relation.class::cast).collect(Collectors.toList());
    }

    @Override
    public Object visitAggregation(GParser.AggregationContext ctx) {
        SimpleGroupBy groupingElements = new SimpleGroupBy(this.getLocation(ctx), ctx.groupingExpressions.stream().map(this::expression).collect(Collectors.toList()));
        return new GroupBy(this.getLocation(ctx), false, (List<GroupingElement>)Lists.newArrayList((Object[])new GroupingElement[]{groupingElements}));
    }

    @Override
    public Object visitSetQuantifier(GParser.SetQuantifierContext ctx) {
        return super.visitSetQuantifier(ctx);
    }

    @Override
    public Object visitJoinRelation(GParser.JoinRelationContext ctx) {
        Relation left = (Relation)this.visit((ParseTree)ctx.left);
        if (ctx.CROSS() != null) {
            Relation right = (Relation)this.visit((ParseTree)ctx.right);
            return new Join(this.getLocation(ctx), Join.Type.CROSS, left, right, Optional.empty());
        }
        Relation right = (Relation)this.visit((ParseTree)ctx.right);
        if (ctx.joinCriteria().ON() == null) {
            throw new IllegalArgumentException("Unsupported join criteria");
        }
        JoinOn criteria = new JoinOn((Expr)this.visit((ParseTree)ctx.joinCriteria().booleanExpression()));
        Join.Type joinType = ctx.joinType().LEFT() != null ? Join.Type.LEFT : (ctx.joinType().RIGHT() != null ? Join.Type.RIGHT : (ctx.joinType().FULL() != null ? Join.Type.FULL : Join.Type.INNER));
        return new Join(this.getLocation(ctx), joinType, left, right, Optional.of(criteria));
    }

    @Override
    public Object visitRelationDefault(GParser.RelationDefaultContext ctx) {
        return super.visitRelationDefault(ctx);
    }

    @Override
    public Object visitJoinType(GParser.JoinTypeContext ctx) {
        return super.visitJoinType(ctx);
    }

    @Override
    public Object visitJoinCriteria(GParser.JoinCriteriaContext ctx) {
        return super.visitJoinCriteria(ctx);
    }

    @Override
    public Object visitTableName(GParser.TableNameContext ctx) {
        Table child = new Table(this.getLocation(ctx), (QualifiedName)this.visit((ParseTree)ctx.tableIdentifier()));
        if (ctx.strictIdentifier() == null) {
            return child;
        }
        return new AliasedRelation(this.getLocation(ctx), (Relation)child, ctx.strictIdentifier().getText(), Collections.emptyList());
    }

    @Override
    public Object visitTableIdentifier(GParser.TableIdentifierContext ctx) {
        if (ctx.db != null) {
            return QualifiedName.of(ctx.db.getText(), ctx.table.getText());
        }
        return QualifiedName.of(ctx.table.getText());
    }

    @Override
    public Object visitNamedExpressionSeq(GParser.NamedExpressionSeqContext ctx) {
        List result = Lists.transform(ctx.namedExpression(), (Function)new Function<GParser.NamedExpressionContext, Expr>(){

            public Expr apply(GParser.NamedExpressionContext e) {
                return ASTBuilder.this.expression(e);
            }
        });
        return new ExprList(this.getLocation(ctx), result.toArray(new Expr[result.size()]));
    }

    private List<SelectItem> visitSelect(GParser.NamedExpressionSeqContext ctx) {
        boolean distinct = false;
        List<SelectItem> list = ctx.namedExpression().stream().map(this::visitNamedExpression).map(expr -> {
            if (expr instanceof UnresolvedStar) {
                String prefix = ((UnresolvedStar)expr).getPrefix();
                if (prefix != null) {
                    QualifiedName q = QualifiedName.of(prefix);
                    return new AllColumns(((UnresolvedStar)expr).getLocation(), q);
                }
                return new AllColumns(expr.getLocation().get());
            }
            if (expr instanceof Alias) {
                return new SingleColumn(expr.getLocation(), ((Alias)expr).getChild(), Optional.of(((Alias)expr).getAlias()));
            }
            return new SingleColumn(expr.getLocation(), (Expr)expr, Optional.empty());
        }).collect(Collectors.toList());
        return list;
    }

    @Override
    public Object visitExpression(GParser.ExpressionContext ctx) {
        return super.visitExpression(ctx);
    }

    @Override
    public Object visitLogicalBinary(GParser.LogicalBinaryContext ctx) {
        int operatorType = ctx.operator.getType();
        Expr left = this.expression(ctx.left);
        Expr right = this.expression(ctx.right);
        switch (operatorType) {
            case 16: {
                return And.create(this.getLocation(ctx), left, right);
            }
            case 15: {
                return Or.create(this.getLocation(ctx), left, right);
            }
        }
        return null;
    }

    @Override
    public Object visitBooleanDefault(GParser.BooleanDefaultContext ctx) {
        return super.visitBooleanDefault(ctx);
    }

    @Override
    public Object visitLogicalNot(GParser.LogicalNotContext ctx) {
        Expr e = this.expression(ctx.booleanExpression());
        return new Not(this.getLocation(ctx), e);
    }

    @Override
    public Object visitPredicated(GParser.PredicatedContext ctx) {
        Expr expr = this.expression(ctx.valueExpression());
        if (ctx.predicate() != null) {
            return this.withPredicate(this.getLocation(ctx), expr, ctx.predicate());
        }
        return expr;
    }

    private Object withPredicate(Optional<NodeLocation> location, Expr expr, GParser.PredicateContext ctx) {
        Expr result;
        boolean NULL;
        boolean not = ctx.NOT() != null;
        boolean bl = NULL = ctx.NULL() != null;
        if (NULL) {
            return not ? new IsNotNull(location, expr) : new IsNull(location, expr);
        }
        switch (ctx.kind.getType()) {
            case 17: {
                result = new In(location, expr, this.expressions(ctx.expression().toArray(new ParserRuleContext[ctx.expression().size()])));
                break;
            }
            case 20: {
                result = new Like(location, expr, this.expression(ctx.pattern));
                break;
            }
            default: {
                throw new AlgoException("Not support type: " + ctx.getText());
            }
        }
        return not ? new Not(location, result) : result;
    }

    @Override
    public Object visitValueExpressionDefault(GParser.ValueExpressionDefaultContext ctx) {
        return super.visitValueExpressionDefault(ctx);
    }

    @Override
    public Object visitArithmeticBinary(GParser.ArithmeticBinaryContext ctx) {
        Expr leftExpr = this.expression(ctx.left);
        Expr rightExpr = this.expression(ctx.right);
        switch (ctx.operator.getType()) {
            case 51: {
                return new Multiply(this.getLocation(ctx), leftExpr, rightExpr);
            }
            case 52: {
                return new Divide(this.getLocation(ctx), leftExpr, rightExpr);
            }
            case 53: {
                return new Remainder(this.getLocation(ctx), leftExpr, rightExpr);
            }
            case 49: {
                return new Add(this.getLocation(ctx), leftExpr, rightExpr);
            }
            case 50: {
                return new Substract(this.getLocation(ctx), leftExpr, rightExpr);
            }
        }
        throw new AlgoException("Not support type: " + ctx.getText());
    }

    @Override
    public Object visitStringAdd(GParser.StringAddContext ctx) {
        Expr leftExpr = this.expression(ctx.left);
        Expr rightExpr = this.expression(ctx.right);
        return new StringAdd(this.getLocation(ctx), leftExpr, rightExpr, "||");
    }

    private Expr expression(ParserRuleContext ctx) {
        return (Expr)ctx.accept((ParseTreeVisitor)this);
    }

    private Expr[] expressions(ParserRuleContext[] expressions) {
        Expr[] result = new Expr[expressions.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Expr)expressions[i].accept((ParseTreeVisitor)this);
        }
        return result;
    }

    @Override
    public Object visitArithmeticUnary(GParser.ArithmeticUnaryContext ctx) {
        Expr value = (Expr)ctx.valueExpression().accept(this);
        switch (ctx.operator.getType()) {
            case 50: {
                return new UnaryMinus(this.getLocation(ctx), value);
            }
            case 49: {
                return value;
            }
        }
        throw new AlgoException("Not support type: " + ctx.getText());
    }

    @Override
    public Object visitComparison(GParser.ComparisonContext ctx) {
        Expr left = this.expression(ctx.left);
        Expr right = this.expression(ctx.right);
        TerminalNode operator = (TerminalNode)ctx.comparisonOperator().getChild(0);
        switch (operator.getSymbol().getType()) {
            case 42: {
                return new Equal(this.getLocation(ctx), left, right);
            }
            case 43: {
                return new NotEqual(this.getLocation(ctx), left, right);
            }
            case 44: {
                return new NotEqual(this.getLocation(ctx), left, right);
            }
            case 45: {
                return new LT(this.getLocation(ctx), left, right);
            }
            case 46: {
                return new LTE(this.getLocation(ctx), left, right);
            }
            case 47: {
                return new GT(this.getLocation(ctx), left, right);
            }
            case 48: {
                return new GTE(this.getLocation(ctx), left, right);
            }
        }
        throw new AlgoException("Not support operator: " + operator.getText());
    }

    @Override
    public Object visitSearchedCase(GParser.SearchedCaseContext ctx) {
        CaseWhenClause[] clauses = new CaseWhenClause[ctx.whenClause().size()];
        for (int i = 0; i < clauses.length; ++i) {
            GParser.WhenClauseContext w = ctx.whenClause(i);
            Expr conditionExpr = this.expression(w.condition);
            Expr resultExpr = this.expression(w.result);
            clauses[i] = new CaseWhenClause(this.getLocation(ctx), conditionExpr, resultExpr, AnyType.BooleanType);
        }
        if (ctx.elseExpression != null) {
            Expr elseExpr = this.expression(ctx.elseExpression);
            return new CaseWhenSearch(this.getLocation(ctx), clauses, elseExpr);
        }
        return new CaseWhenSearch(this.getLocation(ctx), clauses);
    }

    @Override
    public Object visitFunctionCall(GParser.FunctionCallContext ctx) {
        String name = ctx.qualifiedName().getText();
        boolean distinct = ctx.setQuantifier() != null && ctx.setQuantifier().DISTINCT() != null;
        Expr[] exprs = new Expr[ctx.expression().size()];
        for (int i = 0; i < exprs.length; ++i) {
            exprs[i] = (Expr)this.visitExpression(ctx.expression(i));
        }
        return new UnresolvedFuncall(this.getLocation(ctx), name, distinct, exprs);
    }

    @Override
    public Object visitColumnReference(GParser.ColumnReferenceContext ctx) {
        return new UnresolvedAttribute(this.getLocation(ctx), ctx.getText());
    }

    @Override
    public Object visitCast(GParser.CastContext ctx) {
        DataType dataType = (DataType)this.visit((ParseTree)ctx.dataType());
        Expr expr = (Expr)this.visit((ParseTree)ctx.expression());
        return new Cast(this.getLocation(ctx), expr, dataType);
    }

    @Override
    public Object visitConstantDefault(GParser.ConstantDefaultContext ctx) {
        return super.visitConstantDefault(ctx);
    }

    @Override
    public Object visitStar(GParser.StarContext ctx) {
        GParser.QualifiedNameContext q = ctx.qualifiedName();
        return new UnresolvedStar(this.getLocation(ctx), q == null ? null : q.getText());
    }

    @Override
    public Object visitDereference(GParser.DereferenceContext ctx) {
        String attr = ctx.fieldName.getText();
        Expr base = this.expression(ctx.base);
        if (base instanceof UnresolvedAttribute) {
            return ((UnresolvedAttribute)base).derive(this.getLocation(ctx), attr);
        }
        return new UnresolvedExtractValue(this.getLocation(ctx), base, new Literal(this.getLocation(ctx), attr));
    }

    @Override
    public Object visitParenthesizedExpression(GParser.ParenthesizedExpressionContext ctx) {
        return this.expression(ctx.expression());
    }

    @Override
    public Object visitSimpleCase(GParser.SimpleCaseContext ctx) {
        Expr valueExpr = this.expression(ctx.valueExpression());
        CaseWhenClause[] clauses = new CaseWhenClause[ctx.whenClause().size()];
        for (int i = 0; i < clauses.length; ++i) {
            GParser.WhenClauseContext w = ctx.whenClause(i);
            Expr conditionExpr = this.expression(w.condition);
            Expr resultExpr = this.expression(w.result);
            clauses[i] = new CaseWhenClause(this.getLocation(ctx), conditionExpr, resultExpr, AnyType.instance);
        }
        if (ctx.elseExpression != null) {
            Expr elseExpr = this.expression(ctx.elseExpression);
            return new CaseWhenSimple(this.getLocation(ctx), valueExpr, clauses, elseExpr);
        }
        return new CaseWhenSimple(this.getLocation(ctx), valueExpr, clauses);
    }

    @Override
    public Object visitNullLiteral(GParser.NullLiteralContext ctx) {
        return new Literal(this.getLocation(ctx), (Object)null, (DataType)DataType.NullType);
    }

    @Override
    public Object visitTypeConstructor(GParser.TypeConstructorContext ctx) {
        return super.visitTypeConstructor(ctx);
    }

    @Override
    public Object visitNumericLiteral(GParser.NumericLiteralContext ctx) {
        return super.visitNumericLiteral(ctx);
    }

    @Override
    public Object visitBooleanLiteral(GParser.BooleanLiteralContext ctx) {
        String text = ctx.getText();
        Boolean b = Boolean.valueOf(text);
        return new Literal(this.getLocation(ctx), b);
    }

    @Override
    public Object visitStringLiteral(GParser.StringLiteralContext ctx) {
        String text = ctx.getText();
        return new Literal(this.getLocation(ctx), text.substring(1, text.length() - 1));
    }

    @Override
    public Object visitComparisonOperator(GParser.ComparisonOperatorContext ctx) {
        return super.visitComparisonOperator(ctx);
    }

    @Override
    public Object visitBooleanValue(GParser.BooleanValueContext ctx) {
        return super.visitBooleanValue(ctx);
    }

    @Override
    public Object visitPrimitiveDataType(GParser.PrimitiveDataTypeContext ctx) {
        String text = ctx.identifier().getText();
        int int1 = -1;
        int int2 = -1;
        List<TerminalNode> integerValues = ctx.INTEGER_VALUE();
        if (integerValues != null && integerValues.size() > 0) {
            int1 = Integer.parseInt(integerValues.get(0).getText());
            if (integerValues.size() > 1) {
                int2 = Integer.parseInt(integerValues.get(1).getText());
            }
        }
        if ("boolean".equalsIgnoreCase(text)) {
            return DataType.BooleanType;
        }
        if ("integer".equalsIgnoreCase(text)) {
            return DataType.IntegerType;
        }
        if ("long".equalsIgnoreCase(text)) {
            return DataType.LongType;
        }
        if ("double".equalsIgnoreCase(text)) {
            return DataType.DoubleType;
        }
        if ("string".equalsIgnoreCase(text)) {
            return DataType.StringType;
        }
        if ("date".equalsIgnoreCase(text)) {
            return DataType.DateType;
        }
        if ("timestamp".equalsIgnoreCase(text)) {
            return DataType.TimestampType;
        }
        if ("decimal".equalsIgnoreCase(text) || "bigdecimal".equalsIgnoreCase(text)) {
            if (integerValues == null || integerValues.isEmpty()) {
                return DataType.BigDecimalType;
            }
            if (int2 > -1) {
                return DataType.createBigDecimalType(int1, int2);
            }
            return DataType.createBigDecimalType(int1);
        }
        throw new AlgoException("Unsupported datatype: " + text);
    }

    @Override
    public Object visitWhenClause(GParser.WhenClauseContext ctx) {
        return super.visitWhenClause(ctx);
    }

    @Override
    public Object visitQualifiedName(GParser.QualifiedNameContext ctx) {
        return super.visitQualifiedName(ctx);
    }

    @Override
    public Object visitIdentifier(GParser.IdentifierContext ctx) {
        return super.visitIdentifier(ctx);
    }

    @Override
    public Object visitUnquotedIdentifier(GParser.UnquotedIdentifierContext ctx) {
        return super.visitUnquotedIdentifier(ctx);
    }

    @Override
    public Object visitQuotedIdentifierAlternative(GParser.QuotedIdentifierAlternativeContext ctx) {
        return super.visitQuotedIdentifierAlternative(ctx);
    }

    @Override
    public Object visitQuotedIdentifier(GParser.QuotedIdentifierContext ctx) {
        return super.visitQuotedIdentifier(ctx);
    }

    @Override
    public Object visitDecimalLiteral(GParser.DecimalLiteralContext ctx) {
        String text = ctx.getText();
        BigDecimal bd = new BigDecimal(text);
        return new Literal(this.getLocation(ctx), bd, (DataType)DataType.BigDecimalType);
    }

    @Override
    public Object visitIntegerLiteral(GParser.IntegerLiteralContext ctx) {
        String text = ctx.getText();
        Long v = Long.valueOf(text);
        if (v > Integer.MAX_VALUE || v < Integer.MIN_VALUE) {
            return new Literal(this.getLocation(ctx), v);
        }
        return new Literal(this.getLocation(ctx), v.intValue());
    }

    @Override
    public Object visitBigIntLiteral(GParser.BigIntLiteralContext ctx) {
        String text = ctx.getText();
        Long v = Long.valueOf(text.substring(0, text.length() - 1));
        return new Literal(this.getLocation(ctx), v);
    }

    @Override
    public Object visitSmallIntLiteral(GParser.SmallIntLiteralContext ctx) {
        return super.visitSmallIntLiteral(ctx);
    }

    @Override
    public Object visitTinyIntLiteral(GParser.TinyIntLiteralContext ctx) {
        return super.visitTinyIntLiteral(ctx);
    }

    @Override
    public Object visitDoubleLiteral(GParser.DoubleLiteralContext ctx) {
        String text = ctx.getText();
        Double v = new Double(text.substring(0, text.length() - 1));
        return new Literal(this.getLocation(ctx), v);
    }

    @Override
    public Object visitNonReserved(GParser.NonReservedContext ctx) {
        return super.visitNonReserved(ctx);
    }

    public Object visit(ParseTree tree) {
        return super.visit(tree);
    }

    public Object visitChildren(RuleNode node) {
        if (node.getChildCount() >= 1) {
            return node.getChild(0).accept((ParseTreeVisitor)this);
        }
        return null;
    }

    public Object visitTerminal(TerminalNode node) {
        return super.visitTerminal(node);
    }

    public Object visitErrorNode(ErrorNode node) {
        return super.visitErrorNode(node);
    }

    protected Object defaultResult() {
        return super.defaultResult();
    }

    protected Object aggregateResult(Object aggregate, Object nextResult) {
        return super.aggregateResult(aggregate, nextResult);
    }

    protected boolean shouldVisitNextChild(RuleNode node, Object currentResult) {
        return super.shouldVisitNextChild(node, currentResult);
    }

    @Override
    public Object visitSortSet(GParser.SortSetContext ctx) {
        List result = Lists.transform(ctx.order, c -> this.expression((ParserRuleContext)c));
        return new ExprList(this.getLocation(ctx), result.toArray(new Expr[result.size()]));
    }

    @Override
    public Object visitTuple(GParser.TupleContext ctx) {
        List result = Lists.transform(ctx.expression(), (Function)new Function<GParser.ExpressionContext, Expr>(){

            public Expr apply(GParser.ExpressionContext e) {
                return ASTBuilder.this.expression(e);
            }
        });
        return new ExprList(this.getLocation(ctx), result.toArray(new Expr[result.size()]));
    }

    @Override
    public Object visitSingleExpression(GParser.SingleExpressionContext ctx) {
        return super.visitSingleExpression(ctx);
    }

    @Override
    public Object visitPredicate(GParser.PredicateContext ctx) {
        return super.visitPredicate(ctx);
    }

    @Override
    public Object visitQuestion(GParser.QuestionContext ctx) {
        return new Parameter(this.getLocation(ctx), this.parameterPosition++);
    }
}

