/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import java.util.Arrays;
import java.util.HashSet;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.AnyType;
import kd.bos.algo.datatype.FractionalType;
import kd.bos.algo.datatype.IntegralType;
import kd.bos.algo.datatype.NullType;
import kd.bos.algo.datatype.NumericType;
import kd.bos.algo.sql.tree.CaseWhenClause;
import kd.bos.algo.sql.tree.Expr;

public class CaseWhenTypes {
    public static DataType guessDataType(Expr caseWhenExpr, CaseWhenClause[] clauses, boolean hasElse) {
        DataType[] types = new DataType[clauses.length + (hasElse ? 1 : 0)];
        for (int i = 0; i < clauses.length; ++i) {
            types[i] = clauses[i].getResultExpr().getDataType();
        }
        if (hasElse) {
            Expr elseExpr = caseWhenExpr.getChild(caseWhenExpr.getChildrenCount() - 1);
            types[types.length - 1] = elseExpr.getDataType();
        }
        return CaseWhenTypes.guessTypes(caseWhenExpr, types);
    }

    private static DataType guessTypes(Expr caseWhenExpr, DataType[] types) {
        int i;
        boolean hasIntegral = false;
        boolean hasFractionalType = false;
        boolean hasNotNumber = false;
        HashSet<DataType> set = new HashSet<DataType>();
        HashSet<DataType> anySet = new HashSet<DataType>();
        for (i = 0; i < types.length; ++i) {
            DataType type = types[i];
            if (type == AnyType.instance) {
                anySet.add(type);
                continue;
            }
            if (type != DataType.NullType) {
                set.add(type);
            }
            if (!(type instanceof NumericType || type instanceof AnyType || type instanceof NullType)) {
                hasNotNumber = true;
            }
            if (type instanceof IntegralType) {
                hasIntegral = true;
            }
            if (!(type instanceof FractionalType)) continue;
            hasFractionalType = true;
        }
        if (anySet.size() == types.length) {
            return AnyType.instance;
        }
        if (set.isEmpty()) {
            return DataType.NullType;
        }
        if (set.size() == 1) {
            for (i = 0; i < types.length; ++i) {
                if (types[i] instanceof NullType) continue;
                return types[i];
            }
        }
        if (hasNotNumber) {
            throw new AlgoException("Case when only support same datatypes, but " + Arrays.toString(types) + " found, you can use cast(expr as datatype) to cast the same types.\r\n" + caseWhenExpr);
        }
        if (hasFractionalType) {
            return DataType.BigDecimalType;
        }
        if (hasIntegral) {
            return DataType.LongType;
        }
        throw new AlgoException("Can't guess dataType for: " + caseWhenExpr.sql());
    }
}

