/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import java.util.Optional;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.AnyType;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.UnaryExpr;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CaseWhenSearchCalc;
import kd.bos.algo.sql.tree.calc.CaseWhenSearchWithElseCalc;
import kd.bos.algo.sql.tree.calc.CaseWhenSimpleCalc;
import kd.bos.algo.sql.tree.calc.CaseWhenSimpleWithElseCalc;
import kd.bos.algo.sql.tree.calc.CastCalc;
import kd.bos.algo.sql.tree.calc.CompileContext;

public class Cast
extends UnaryExpr {
    private DataType dataType;

    public Cast(Optional<NodeLocation> location, Expr child, DataType dataType) {
        super(location, child, AnyType.instance);
        if (dataType.equals(DataType.DoubleType)) {
            dataType = DataType.BigDecimalType;
        }
        this.dataType = dataType;
    }

    @Override
    public String sql() {
        if (this.location.isPresent() && ((NodeLocation)this.location.get()).getText() != null) {
            return ((NodeLocation)this.location.get()).getText();
        }
        return "CAST(" + this.getChild().sql() + " as " + this.dataType.getName() + ")";
    }

    @Override
    public DataType createDataType() {
        return this.dataType;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCast(this, context);
    }

    @Override
    public Calc compile(CompileContext context) {
        Calc child = this.compileChild(context, 0);
        if (child instanceof CaseWhenSearchCalc || child instanceof CaseWhenSearchWithElseCalc || child instanceof CaseWhenSimpleCalc || child instanceof CaseWhenSimpleWithElseCalc) {
            return new CastCalc(this, child, this.dataType);
        }
        if (this.getChild(0).getDataType() == this.dataType) {
            return child;
        }
        return new CastCalc(this, child, this.dataType);
    }
}

