/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import java.util.Locale;
import java.util.Optional;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.AnyType;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.UnaryExpr;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CastCalc;
import kd.bos.algo.sql.tree.calc.CompileContext;

public class ConstantTypeFun
extends UnaryExpr {
    private String funcName;
    private DataType targetType;

    public ConstantTypeFun(String funcName, Optional<NodeLocation> location, Expr child) {
        super(location, child, AnyType.instance);
        this.funcName = funcName;
        this.initTargetType(funcName);
    }

    @Override
    public String sql() {
        return this.funcName + "(" + this.getChild().sql() + ")";
    }

    @Override
    public DataType getDataType() {
        return this.targetType;
    }

    @Override
    public DataType createDataType() {
        return this.targetType;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return null;
    }

    @Override
    public Calc compile(CompileContext context) {
        return new CastCalc(this, this.compileChild(context, 0), this.targetType);
    }

    private void initTargetType(String funcName) {
        switch (funcName.toLowerCase(Locale.ENGLISH)) {
            case "int": 
            case "integer": {
                this.targetType = DataType.IntegerType;
                break;
            }
            case "long": {
                this.targetType = DataType.LongType;
                break;
            }
            case "decimal": 
            case "bigdecimal": {
                this.targetType = DataType.BigDecimalType;
                break;
            }
            case "bool": 
            case "boolean": {
                this.targetType = DataType.BooleanType;
                break;
            }
            case "string": {
                this.targetType = DataType.StringType;
                break;
            }
            default: {
                throw AlgoException.create("This function not support: %s", funcName);
            }
        }
    }
}

