/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import kd.bos.algo.DataType;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.LeafExpr;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CompileContext;
import kd.bos.algo.sql.tree.calc.ConstantCalc;

public class Keyword
extends LeafExpr {
    private static HashSet<String> keywords = new HashSet();
    private String name;

    public static Keyword of(String name) {
        if (keywords.contains(name.toUpperCase())) {
            return new Keyword(name);
        }
        return null;
    }

    public Keyword(String name) {
        super(Optional.empty());
        this.name = name;
    }

    @Override
    public DataType createDataType() {
        return DataType.UnknownType;
    }

    @Override
    public String sql() {
        return this.name;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return null;
    }

    @Override
    public Calc compile(CompileContext context) {
        return new ConstantCalc(this, this.name);
    }

    static {
        keywords.addAll(Arrays.asList("YEAR", "MONTH", "DAY", "MINUTE", "HOUR", "SECOND", "Y", "M", "D"));
    }
}

