/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.SelectItem;

public class SingleColumn
extends SelectItem {
    private final Optional<String> alias;
    private Expr expression;

    public SingleColumn(Expr expression) {
        this(Optional.empty(), expression, Optional.empty());
    }

    public SingleColumn(Expr expression, Optional<String> alias) {
        this(Optional.empty(), expression, alias);
    }

    public SingleColumn(Expr expression, String alias) {
        this(Optional.empty(), expression, Optional.of(alias));
    }

    public SingleColumn(NodeLocation location, Expr expression, Optional<String> alias) {
        this(Optional.of(location), expression, alias);
    }

    public SingleColumn(Optional<NodeLocation> location, Expr expression, Optional<String> alias) {
        super(location);
        Objects.requireNonNull(expression, "expression is null");
        Objects.requireNonNull(alias, "alias is null");
        this.expression = expression;
        this.alias = alias;
    }

    public Optional<String> getAlias() {
        return this.alias;
    }

    public Expr getExpression() {
        return this.expression;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SingleColumn other = (SingleColumn)obj;
        return Objects.equals(this.alias, other.alias) && Objects.equals(this.expression, other.expression);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.expression);
    }

    public String toString() {
        return this.sql();
    }

    public String sql() {
        if (this.alias.isPresent()) {
            return this.expression.sql() + " " + this.alias.get();
        }
        return this.expression.sql();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSingleColumn(this, context);
    }

    public List<Expr> getChildren() {
        return ImmutableList.of((Object)this.expression);
    }
}

