/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.sql.schema.FuncFactory;
import kd.bos.algo.sql.schema.Schema;
import kd.bos.algo.sql.tree.Abs;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Concat;
import kd.bos.algo.sql.tree.ConstantTypeFun;
import kd.bos.algo.sql.tree.Contains;
import kd.bos.algo.sql.tree.EndsWith;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.Lower;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.NullToZero;
import kd.bos.algo.sql.tree.Round;
import kd.bos.algo.sql.tree.StartsWith;
import kd.bos.algo.sql.tree.Unresolved;
import kd.bos.algo.sql.tree.Upper;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CompileContext;
import kd.bos.algo.sql.tree.calc.NotSupportCalc;
import kd.bos.algo.sql.tree.func.FuncDef;

public class UnresolvedFuncall
extends Expr
implements Unresolved {
    private String name;
    private boolean distinct;

    public UnresolvedFuncall(Optional<NodeLocation> location, String name, boolean distinct, Expr[] exprs) {
        super(location, exprs, UnresolvedFuncall.repeatDataTypes(DataType.UnknownType, exprs == null ? 0 : exprs.length));
        this.name = name;
        this.distinct = distinct;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public String sql() {
        return this.name + "(" + (this.distinct ? "distinct " : "") + this.joinChildrenSql(this.children) + ")";
    }

    @Override
    public DataType createDataType() {
        return DataType.UnknownType;
    }

    @Override
    public Expr resolve(Schema schema) {
        FuncDef funcDef;
        Expr result = null;
        FuncFactory factory = schema.getFuncFactory();
        if (factory != null && (funcDef = factory.lookupFunc(this.name, this.children)) != null) {
            result = funcDef.createExpr(this.children);
        }
        if ("Concat".equalsIgnoreCase(this.name)) {
            return new Concat(this.location, this.children);
        }
        if ("Contains".equalsIgnoreCase(this.name)) {
            Preconditions.checkArgument((this.children.length == 2 ? 1 : 0) != 0, (Object)"Contains() needs two argments.");
            return new Contains((Optional<NodeLocation>)this.location, this.children[0], this.children[1]);
        }
        if ("StartsWith".equalsIgnoreCase(this.name)) {
            Preconditions.checkArgument((this.children.length == 2 ? 1 : 0) != 0, (Object)"StartsWith() needs two argments.");
            return new StartsWith((Optional<NodeLocation>)this.location, this.children[0], this.children[1]);
        }
        if ("EndsWith".equalsIgnoreCase(this.name)) {
            Preconditions.checkArgument((this.children.length == 2 ? 1 : 0) != 0, (Object)"EndsWith() needs two argments.");
            return new EndsWith((Optional<NodeLocation>)this.location, this.children[0], this.children[1]);
        }
        if ("Lower".equalsIgnoreCase(this.name)) {
            Preconditions.checkArgument((this.children.length == 1 ? 1 : 0) != 0, (Object)"Lower() needs one argments.");
            return new Lower(this.location, this.children[0]);
        }
        if ("Upper".equalsIgnoreCase(this.name)) {
            Preconditions.checkArgument((this.children.length == 1 ? 1 : 0) != 0, (Object)"Upper() needs one argments.");
            return new Upper(this.location, this.children[0]);
        }
        if ("Abs".equalsIgnoreCase(this.name)) {
            Preconditions.checkArgument((this.children.length == 1 ? 1 : 0) != 0, (Object)"Abs() needs one argments.");
            return new Abs(this.location, this.children[0]);
        }
        if ("Round".equalsIgnoreCase(this.name)) {
            Preconditions.checkArgument((this.children.length == 2 ? 1 : 0) != 0, (Object)"Round() needs two argments.");
            return new Round((Optional<NodeLocation>)this.location, this.children[0], this.children[1]);
        }
        if ("Int".equalsIgnoreCase(this.name) || "Integer".equalsIgnoreCase(this.name) || "String".equalsIgnoreCase(this.name) || "Decimal".equalsIgnoreCase(this.name) || "Long".equalsIgnoreCase(this.name) || "Boolean".equalsIgnoreCase(this.name) || "bool".equalsIgnoreCase(this.name) || "bigdecimal".equalsIgnoreCase(this.name)) {
            Preconditions.checkArgument((this.children.length == 1 ? 1 : 0) != 0, (Object)(this.name + " needs one argments."));
            return new ConstantTypeFun(this.name, this.location, this.children[0]);
        }
        if ("NullToZero".equalsIgnoreCase(this.name)) {
            Preconditions.checkArgument((this.children.length == 1 ? 1 : 0) != 0, (Object)"NullToZero needs one argments.");
            return new NullToZero(this.location, this.children[0]);
        }
        if (result == null) {
            throw AlgoException.create("Function %s not found.", this.name);
        }
        return result;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitUnresolvedFuncall(this, context);
    }

    @Override
    public Calc compile(CompileContext context) {
        return new NotSupportCalc(this, this.getClass().getName());
    }

    public String[] getArguments() {
        String[] fields;
        if (this.children != null) {
            fields = new String[this.children.length];
            for (int i = 0; i < this.children.length; ++i) {
                fields[i] = this.children[i].toString();
            }
        } else {
            List<Expr> children = this.getChildren();
            fields = new String[children.size()];
            for (int i = 0; i < children.size(); ++i) {
                fields[i] = children.get(i).toString();
            }
        }
        return fields;
    }
}

