/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.agg;

import java.util.Optional;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.AnyType;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.BinaryExpr;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.agg.IAgg;
import kd.bos.algo.sql.tree.calc.ArrayCalc;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CompileContext;

public abstract class AggWithPropertyExpr
extends BinaryExpr
implements IAgg {
    private String func;

    public AggWithPropertyExpr(Optional<NodeLocation> location, Expr expr, Expr propertyExpr, String func, DataType inputType) {
        super(location, expr, propertyExpr, inputType, AnyType.instance);
        this.func = func;
    }

    @Override
    public DataType createDataType() {
        return this.children[1].getDataType();
    }

    @Override
    public String sql() {
        return this.func + "(" + this.children[0].sql() + " , " + this.children[1].sql() + ")";
    }

    @Override
    public String getFunc() {
        return this.func;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAggWithPropertyExpr(this, context);
    }

    @Override
    public Calc compile(CompileContext context) {
        return new ArrayCalc(this, this.compileChildren(context));
    }
}

