/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.calc;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.algo.RowFeature;
import kd.bos.algo.sql.interpret.ExplicitCheck;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.util.AlgoUtil;

public final class DivideCalc
extends Calc {
    private Calc calc1;
    private Calc calc2;

    public DivideCalc(Expr expr, Calc calc1, Calc calc2) {
        super(expr);
        this.calc1 = calc1;
        this.calc2 = calc2;
    }

    @Override
    public Object executeImpl(RowFeature row1, RowFeature row2) {
        Number left = ExplicitCheck.checkNumber(this.calc1.execute(row1, row2), "Divide only apply to number, but %s found ", this.expr);
        if (left == null) {
            return null;
        }
        Number right = ExplicitCheck.checkNumber(this.calc2.execute(row1, row2), "Divide only apply to number, but %s found ", this.expr);
        if (right == null) {
            return null;
        }
        if (left instanceof BigDecimal) {
            return AlgoUtil.toBigDecimal(left).divide(AlgoUtil.toBigDecimal(right), 10, RoundingMode.HALF_UP);
        }
        if (left instanceof Integer) {
            if (right instanceof Integer) {
                return (Integer)left / (Integer)right;
            }
            if (right instanceof Long) {
                return left.longValue() / right.longValue();
            }
            return AlgoUtil.toBigDecimal(left).divide(AlgoUtil.toBigDecimal(right), 10, RoundingMode.HALF_UP).intValue();
        }
        if (left instanceof Long) {
            if (right instanceof Long || right instanceof Integer) {
                return (Long)left / right.longValue();
            }
            return AlgoUtil.toBigDecimal(left).divide(AlgoUtil.toBigDecimal(right), 10, RoundingMode.HALF_UP).intValue();
        }
        if (left instanceof Double) {
            return (Double)left / Double.parseDouble(right.toString());
        }
        throw this.wrapException("Divide eval error!");
    }
}

