/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.calc;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import kd.bos.algo.RowFeature;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.util.AlgoUtil;

public final class InCalc
extends Calc {
    private Calc[] children;
    private HashSet<Object> set;
    private InKey cacheKey = new InKey(1);

    public InCalc(Expr expr, Calc[] children) {
        super(expr);
        this.children = children;
    }

    @Override
    public Object executeImpl(RowFeature row1, RowFeature row2) {
        Object value = this.children[0].execute(row1, row2);
        if (value == null) {
            return Boolean.FALSE;
        }
        if (this.set == null) {
            this.buildSet(row1, row2);
        }
        return this.set.contains(this.wrapKey(value));
    }

    private Object wrapKey(Object value) {
        this.cacheKey.setValue(value);
        return this.cacheKey;
    }

    private void buildSet(RowFeature row1, RowFeature row2) {
        this.set = new HashSet();
        Object v = null;
        for (int i = 1; i < this.children.length; ++i) {
            v = this.children[i].execute(row1, row2);
            if (v == null) continue;
            if (v instanceof Collection) {
                for (Object child : (Collection)v) {
                    if (child == null) continue;
                    this.set.add(this.makeKey(child));
                }
                continue;
            }
            if (v.getClass().isArray()) {
                int len = Array.getLength(v);
                for (int ii = 0; ii < len; ++ii) {
                    Object child = Array.get(v, ii);
                    if (child == null) continue;
                    this.set.add(this.makeKey(child));
                }
                continue;
            }
            this.set.add(this.makeKey(v));
        }
    }

    private Object makeKey(Object value) {
        return new InKey(value);
    }

    private static class InKey {
        private Object value;
        private int hashCode;

        InKey(Object value) {
            this.setValue(value);
        }

        private void setValue(Object value) {
            if (value instanceof Number) {
                this.value = AlgoUtil.toBigDecimal(value);
                this.hashCode = ((BigDecimal)this.value).intValue();
            } else {
                this.value = value;
                this.hashCode = value.hashCode();
            }
        }

        public boolean equals(Object x) {
            return x != null && AlgoUtil.equal(this.value, ((InKey)x).value);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

