/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.calc;

import java.util.Date;
import kd.bos.algo.RowFeature;
import kd.bos.algo.sql.interpret.ExplicitCheck;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.util.AlgoUtil;

public final class LTECalc
extends Calc {
    private Calc calc1;
    private Calc calc2;

    public LTECalc(Expr expr, Calc calc1, Calc calc2) {
        super(expr);
        this.calc1 = calc1;
        this.calc2 = calc2;
    }

    @Override
    public Object executeImpl(RowFeature row1, RowFeature row2) {
        Object left = this.calc1.execute(row1, row2);
        Object right = this.calc2.execute(row1, row2);
        if (left == null && right == null) {
            return Boolean.TRUE;
        }
        if (left == null) {
            return Boolean.TRUE;
        }
        if (right == null) {
            return Boolean.FALSE;
        }
        if (left instanceof Number && right instanceof Number) {
            return AlgoUtil.compareNumber((Number)left, (Number)right) <= 0;
        }
        if (left instanceof String) {
            return ((String)left).compareTo(right.toString()) <= 0;
        }
        if (left instanceof Date) {
            Date d2 = ExplicitCheck.checkDate(right, left.toString() + "Date <= %s, right expr should Date, but " + right.getClass() + " found.", this.expr);
            return ((Date)left).compareTo(d2) <= 0;
        }
        throw this.wrapException("<= only support Number, String, Date, Timestamp, but " + left.getClass() + " found.");
    }
}

