/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.calc;

import java.math.BigDecimal;
import kd.bos.algo.RowFeature;
import kd.bos.algo.sql.interpret.ExplicitCheck;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.calc.Calc;

public final class RoundCalc
extends Calc {
    private Calc calc1;
    private Calc calc2;

    public RoundCalc(Expr expr, Calc calc1, Calc calc2) {
        super(expr);
        this.calc1 = calc1;
        this.calc2 = calc2;
    }

    @Override
    public Object executeImpl(RowFeature row1, RowFeature row2) {
        Object value = this.calc1.execute(row1, row2);
        if (value == null) {
            return null;
        }
        Integer right = ExplicitCheck.checkInteger(this.calc2.execute(row1, row2), "round second argument should be Integer, but %s found.", this.expr);
        if (value instanceof Integer || value instanceof Long) {
            return value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).setScale((int)right, 4);
        }
        if (value instanceof Double) {
            return BigDecimal.valueOf((Double)value).setScale((int)right, 4);
        }
        throw this.wrapException("Number value required, but found " + value + " of " + value.getClass().getName());
    }
}

