/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.func;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.AnyType;
import kd.bos.algo.sql.schema.FuncFactory;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.func.FormulaExpr;
import kd.bos.algo.sql.tree.func.FuncDef;
import kd.bos.algo.sql.tree.func.PreRowValueFuncDef;

public class FormulaFuncFactory
implements FuncFactory {
    private static final Map<String, DataType> allowFunc = new HashMap<String, DataType>();
    private static final Map<String, FuncDef> defs = new HashMap<String, FuncDef>();

    public static void registerDef(FuncDef def) {
        defs.put(def.getName().toLowerCase(), def);
    }

    @Override
    public FuncDef lookupFunc(String name, Expr[] children) {
        String key = name.toLowerCase();
        FuncDef def = defs.get(key);
        if (def != null) {
            return def;
        }
        if (!allowFunc.containsKey(key)) {
            return null;
        }
        return new FormulaFuncDef(name, allowFunc.get(key));
    }

    static {
        allowFunc.put("year", DataType.IntegerType);
        allowFunc.put("month", DataType.IntegerType);
        allowFunc.put("day", DataType.IntegerType);
        allowFunc.put("len", DataType.IntegerType);
        allowFunc.put("now", DataType.DateType);
        allowFunc.put("date", DataType.DateType);
        allowFunc.put("to_date", DataType.DateType);
        allowFunc.put("dateadd", DataType.DateType);
        allowFunc.put("datedif", DataType.IntegerType);
        allowFunc.put("substr", DataType.StringType);
        allowFunc.put("left", DataType.StringType);
        allowFunc.put("right", DataType.StringType);
        allowFunc.put("replace", DataType.StringType);
        allowFunc.put("to_char", DataType.StringType);
        FormulaFuncFactory.registerDef(new PreRowValueFuncDef());
    }

    private static class FormulaFuncDef
    implements FuncDef {
        private String name;
        private DataType resultType;

        public FormulaFuncDef(String name, DataType resultType) {
            this.name = name;
            this.resultType = resultType;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Expr createExpr(Expr[] children) {
            if (children == null || children.length == 0) {
                return new FormulaExpr(this.name, this.resultType);
            }
            return new FormulaExpr(this.name, children, Expr.repeatDataTypes(AnyType.instance, children.length), this.resultType);
        }
    }
}

