/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.func.calc;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.RowFeature;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.ExprParser;
import kd.bos.formula.excel.FunDef;

public class FormulaCalc
extends Calc {
    private Calc[] children;
    private String[] argNames;
    private kd.bos.formula.excel.Expr formulaExpr;
    private Map<String, Object> params;

    public FormulaCalc(Expr expr, Calc[] children, String name, DataType resultType) {
        super(expr);
        this.children = children;
        FunDef ff = FunDef.getFunDef((String)name);
        if (ff == null) {
            throw new AlgoException("Function '%s' not found.", name);
        }
        StringBuilder formula = new StringBuilder(name);
        formula.append('(');
        if (children != null) {
            this.argNames = new String[children.length];
            for (int i = 0; i < children.length; ++i) {
                String key;
                this.argNames[i] = key = "arg__" + i;
                formula.append(key);
                if (i >= children.length - 1) continue;
                formula.append(',');
            }
            this.params = new HashMap<String, Object>(children.length);
        }
        formula.append(')');
        this.formulaExpr = ExprParser.parse((String)formula.toString());
    }

    @Override
    public Object executeImpl(RowFeature row1, RowFeature row2) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.params.put(this.argNames[i], this.children[i].execute(row1, row2));
            }
            return FormulaEngine.execExcelFormula((kd.bos.formula.excel.Expr)this.formulaExpr, this.params);
        }
        return FormulaEngine.execExcelFormula((kd.bos.formula.excel.Expr)this.formulaExpr);
    }
}

