/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.star;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.sql.schema.Column;
import kd.bos.algo.sql.schema.Schema;
import kd.bos.algo.sql.schema.Table;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.bind.ColumnRef;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CompileContext;
import kd.bos.algo.sql.tree.calc.NotSupportCalc;
import kd.bos.algo.sql.tree.star.AllColumn;

public class SchemaAllColumn
extends Expr
implements AllColumn {
    public SchemaAllColumn(Optional<NodeLocation> location, Schema schema) {
        super(location, SchemaAllColumn.extractExprs(schema), SchemaAllColumn.extractTypes(schema));
    }

    private static Expr[] extractExprs(Schema schema) {
        ArrayList<Expr> result = new ArrayList<Expr>();
        HashSet<String> duplication = new HashSet<String>();
        for (Table rel : schema.getTables()) {
            SchemaAllColumn.extractExprs(rel, result, duplication);
        }
        return result.toArray(new Expr[result.size()]);
    }

    private static DataType[] extractTypes(Schema schema) {
        ArrayList<DataType> result = new ArrayList<DataType>();
        HashSet<String> duplication = new HashSet<String>();
        for (Table rel : schema.getTables()) {
            SchemaAllColumn.extractTypes(rel, result, duplication);
        }
        return result.toArray(new DataType[result.size()]);
    }

    private static void extractExprs(Table relation, List<Expr> result, HashSet<String> duplication) {
        Column[] columns = relation.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!duplication.add(columns[i].getName())) {
                throw AlgoException.create("'*' is not allowed, because duplication field name %s in two dataset.", columns[i].getName());
            }
            result.add(new ColumnRef(Optional.empty(), columns[i], null));
        }
    }

    private static void extractTypes(Table relation, List<DataType> result, HashSet<String> duplication) {
        Column[] columns = relation.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            result.add(columns[i].getDataType());
        }
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return null;
    }

    @Override
    public DataType getDataType() {
        return null;
    }

    @Override
    public DataType createDataType() {
        return null;
    }

    @Override
    public String sql() {
        return null;
    }

    @Override
    public ColumnRef[] getAll() {
        return (ColumnRef[])this.children;
    }

    @Override
    public Calc compile(CompileContext context) {
        return new NotSupportCalc(this, this.getClass().getName());
    }
}

