/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.storage;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CacheHint;
import kd.bos.algo.RowMeta;
import kd.bos.algo.storage.CacheStorage;
import kd.bos.algo.storage.CacheWriter;
import kd.bos.algo.storage.Page;
import kd.bos.thread.ThreadLifeCycleManager;

public class MainThread
extends Thread {
    private CountDownLatch latch = new CountDownLatch(1);
    private CacheWriter writer;
    private String key;
    private RowMeta rowMeta;
    private CacheHint hint;
    private CacheStorage storage;
    private boolean started = false;
    private Runnable wrapRunnable;
    private LinkedBlockingQueue<Page> queue = new LinkedBlockingQueue(4);
    private volatile boolean end = false;
    private volatile AlgoException error;

    public MainThread(CacheWriter writer, String key, RowMeta rowMeta, CacheHint hint, CacheStorage storage) {
        this.writer = writer;
        this.key = key;
        this.rowMeta = rowMeta;
        this.hint = hint;
        this.storage = storage;
        this.wrapRunnable = ThreadLifeCycleManager.wrapRunnable((Runnable)new Runnable(){

            @Override
            public void run() {
                Page page = null;
                try {
                    while (true) {
                        try {
                            page = (Page)MainThread.this.queue.poll(10L, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        if (page == null) {
                            if (!MainThread.this.end) continue;
                            if (MainThread.this.error == null) {
                                if (!MainThread.this.queue.isEmpty()) continue;
                            }
                            break;
                        }
                        if (MainThread.this.error != null) {
                            break;
                        }
                        MainThread.this.processOne(page);
                    }
                }
                finally {
                    MainThread.this.latch.countDown();
                }
            }
        });
    }

    public void end() {
        this.end = true;
    }

    @Override
    public void run() {
        this.wrapRunnable.run();
    }

    private void processOne(Page page) {
        try {
            this.writePage(this.writer, page);
        }
        catch (AlgoException e) {
            this.error = e;
            this.end = true;
        }
        catch (Exception e) {
            this.error = new AlgoException(e);
            this.end = true;
        }
    }

    public void cancelOnException(AlgoException error) {
        this.error = error;
        this.end = true;
        this.waitDone();
        if (this.writer.hasFlushed()) {
            this.delete(this.key, false);
        }
    }

    public void waitDone() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void writePage(CacheWriter writer, Page page) throws IOException {
        String key2 = this.getPageKey(page.getPageId());
        byte[] bytes = page.toByteArray();
        writer.put(key2, bytes);
    }

    private void delete(String id, boolean throwOnException) {
        block2: {
            try {
                this.storage.delete(id);
            }
            catch (Exception e) {
                if (!throwOnException) break block2;
                throw new AlgoException(e, "error delete: " + e.getMessage(), new Object[0]);
            }
        }
    }

    public String getPageKey(int page) {
        return "page" + page;
    }

    public AlgoException getError() {
        return this.error;
    }

    public void addPage(Page page) {
        if (this.error != null) {
            this.latch.countDown();
            throw this.error;
        }
        try {
            this.queue.put(page);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!this.started) {
            this.start();
            this.started = true;
        }
    }
}

