/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.storage;

import java.io.IOException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.dataset.cache.kv.KVSerializer;
import kd.bos.algo.dataset.cache.kv.KVSerializerFactory;
import kd.bos.algo.serde.RowSerde;

public class Page {
    private int pageId;
    private int rowCount;
    private KVSerializer serializer;

    public Page(int pageId, RowSerde rowSerde) {
        this.serializer = KVSerializerFactory.getKVSerializer(AlgoConfiguration.DATASETCACHE_SERIALIZE_TYPE.getString(), rowSerde);
        this.pageId = pageId;
    }

    public void addRow(RowMeta rowMeta, Row row) {
        this.serializer.serialize(row, rowMeta);
        ++this.rowCount;
    }

    public byte[] toByteArray() throws IOException {
        return this.serializer.toByte();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getPageId() {
        return this.pageId;
    }
}

