/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.storage;

import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algo.AlgoException;
import kd.bos.algo.storage.CacheStorage;
import kd.bos.algo.storage.FileSystemStorage;
import kd.bos.algo.storage.KVStorage;
import kd.bos.algo.storage.local.LocalStorage3;

public class StorageFactory {
    protected static String DEFAULTKEY = "algo.storage";
    protected static String ConfigKeyPrefix = "algo.storage.";
    private static ConcurrentHashMap<String, FileSystemStorage> file_instances = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, KVStorage> kv_instances = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, CacheStorage> tempfile_instances = new ConcurrentHashMap();

    public static CacheStorage getTempFileStorage() {
        return StorageFactory.createTempFileStorageByClassName("kd.bos.algo.storage.tempfile.FileServerTempFileStorage");
    }

    public static FileSystemStorage getLocalFileSystemStorage() {
        return StorageFactory.getLocalStorage();
    }

    public static CacheStorage getKVStorage() {
        return StorageFactory.getRedisStorage();
    }

    public static FileSystemStorage get(String configKey) {
        String v;
        if (configKey == null) {
            configKey = DEFAULTKEY;
        }
        if ((v = System.getProperty(configKey)) == null) {
            v = System.getProperty(DEFAULTKEY);
        }
        if (v == null) {
            v = "local";
        }
        return StorageFactory.getStorageByType(v);
    }

    private static FileSystemStorage getStorageByType(String type) {
        String className = System.getProperty(ConfigKeyPrefix + type + ".class");
        if (className != null) {
            FileSystemStorage storage = file_instances.get(className);
            if (storage != null) {
                return storage;
            }
            return StorageFactory.createByClassName(className);
        }
        FileSystemStorage storage = file_instances.get(type);
        if (storage != null) {
            return storage;
        }
        if (!"local".equalsIgnoreCase(type)) {
            throw new AlgoException("Unsupported storage type:" + type);
        }
        storage = StorageFactory.getLocalStorage();
        file_instances.put(type, storage);
        return storage;
    }

    private static KVStorage getRedisStorage() {
        return StorageFactory.createKVStorageByClassName("kd.bos.algo.storage.redis.RedisStorage");
    }

    private static FileSystemStorage getLocalStorage() {
        return new LocalStorage3();
    }

    private static FileSystemStorage createByClassName(String className) {
        if (file_instances.containsKey(className)) {
            return file_instances.get(className);
        }
        try {
            Class<?> clazz = Class.forName(className);
            FileSystemStorage storage = (FileSystemStorage)clazz.newInstance();
            file_instances.put(className, storage);
            return storage;
        }
        catch (Exception e) {
            throw new AlgoException("Can't create storage by class:" + className, e);
        }
    }

    private static KVStorage createKVStorageByClassName(String className) {
        if (kv_instances.containsKey(className)) {
            return kv_instances.get(className);
        }
        try {
            Class<?> clazz = Class.forName(className);
            KVStorage storage = (KVStorage)clazz.newInstance();
            kv_instances.put(className, storage);
            return storage;
        }
        catch (Exception e) {
            throw new AlgoException("Can't create storage by class:" + className, e);
        }
    }

    private static CacheStorage createTempFileStorageByClassName(String className) {
        if (tempfile_instances.containsKey(className)) {
            return tempfile_instances.get(className);
        }
        try {
            Class<?> clazz = Class.forName(className);
            CacheStorage storage = (CacheStorage)clazz.newInstance();
            tempfile_instances.put(className, storage);
            return storage;
        }
        catch (Exception e) {
            throw new AlgoException("Can't create storage by class:" + className, e);
        }
    }
}

