/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.storage;

import java.io.IOException;
import kd.bos.algo.storage.CacheWriter;
import kd.bos.algo.util.ZipUtil;

public class ZipWriter
implements CacheWriter {
    private CacheWriter inner;

    public ZipWriter(CacheWriter inner) {
        this.inner = inner;
    }

    @Override
    public String putMeta(String key, byte[] value) throws IOException {
        return this.inner.put(key, value);
    }

    @Override
    public String put(String key, byte[] value) throws IOException {
        return this.inner.put(key, ZipUtil.zip(value));
    }

    @Override
    public void flush() throws IOException {
        this.inner.flush();
    }

    public CacheWriter getInner() {
        return this.inner;
    }

    @Override
    public boolean hasFlushed() {
        return this.inner.hasFlushed();
    }

    public static CacheWriter wrapToZIPWriter(CacheWriter writer, String compressor) {
        if ("zip".equals(compressor)) {
            return new ZipWriter(writer);
        }
        return writer;
    }
}

