/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.storage.local;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.storage.FileSystemStorage;
import org.apache.commons.io.FilenameUtils;

public class LocalStorage
implements FileSystemStorage,
AutoCloseable {
    private static int index = 0;
    private static String[] tempDirs = AlgoConfiguration.IO_TMP_DIRS.getString().split(",");
    private String baseFilePath = null;

    public LocalStorage() {
        this(LocalStorage.getBaseFilePath());
    }

    private static String getBaseFilePath() {
        return tempDirs[index++ % tempDirs.length];
    }

    public LocalStorage(String baseFilePath) {
        this.baseFilePath = baseFilePath;
        File baseFile = new File(FilenameUtils.normalize((String)baseFilePath));
        baseFile.mkdirs();
    }

    @Override
    public boolean createDirectory(String url, long timeout) throws IOException {
        String fullPath = this.baseFilePath + "/" + url;
        File file = new File(FilenameUtils.normalize((String)fullPath));
        boolean r = file.mkdirs();
        file.deleteOnExit();
        return r;
    }

    @Override
    public OutputStream create(String url, long timeout) throws IOException {
        String fullPath = this.baseFilePath + "/" + url;
        File file = new File(FilenameUtils.normalize((String)fullPath));
        file.getParentFile().mkdirs();
        file.deleteOnExit();
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    @Override
    public InputStream open(String url) throws IOException {
        String fullPath = this.baseFilePath + "/" + url;
        return new BufferedInputStream(new FileInputStream(FilenameUtils.normalize((String)fullPath)));
    }

    @Override
    public boolean exists(String url) {
        String fullPath = this.baseFilePath + "/" + url;
        File file = new File(FilenameUtils.normalize((String)fullPath));
        return file.exists();
    }

    @Override
    public boolean delete(String url) {
        String fullPath = this.baseFilePath + "/" + url;
        File file = new File(FilenameUtils.normalize((String)fullPath));
        return this.delete(file);
    }

    private boolean delete(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.delete(child);
            }
        }
        return file.delete();
    }

    @Override
    public String getName() {
        return "localfile";
    }

    @Override
    public void close() throws Exception {
        File file = new File(FilenameUtils.normalize((String)this.baseFilePath));
        this.delete(file);
    }
}

