/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util;

import java.util.Arrays;
import kd.bos.algo.AlgoException;
import kd.bos.algo.util.AlgoUtil;

public final class ArrayKey {
    public static final ArrayKey empty = new ArrayKey(new Object[0]);
    private Object[] array;
    private int hash;

    public ArrayKey(Object[] array) {
        this.array = array;
        this.hash = Arrays.hashCode(array);
    }

    public boolean equals(Object x) {
        return x != null && Arrays.equals(this.array, ((ArrayKey)x).array);
    }

    public int hashCode() {
        return this.hash;
    }

    public Object get(int index) {
        return this.array[index];
    }

    public Object[] getArray() {
        return this.array;
    }

    public int length() {
        return this.array.length;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }

    public int compareTo(ArrayKey arrayKey) {
        Object[] array1 = arrayKey.getArray();
        for (int i = 0; i < this.array.length; ++i) {
            int r;
            Object o1 = this.array[i];
            Object o2 = array1[i];
            if (o1 == null) {
                if (o2 == null) continue;
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof Number && o2 instanceof Number) {
                r = AlgoUtil.compareNumber((Number)o1, (Number)o2);
                if (r == 0) continue;
                return r;
            }
            if (o1 instanceof Number && !(o2 instanceof Number)) {
                throw new AlgoException("Value not compatible," + o1 + "(" + o1.getClass() + ")<>" + o2 + "(" + o2.getClass() + ")");
            }
            if (!(o1 instanceof Number) && o2 instanceof Number) {
                throw new AlgoException("Value not compatible," + o1 + "(" + o1.getClass() + ")<>" + o2 + "(" + o2.getClass() + ")");
            }
            if (o1 instanceof Comparable) {
                r = ((Comparable)o1).compareTo(o2);
                if (r == 0) continue;
                return r;
            }
            throw new AlgoException("Value not be comparable:" + o1);
        }
        return 0;
    }
}

