/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util;

import kd.bos.algo.AlgoException;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.util.Aggregator;

public class CustomizedAggregator
extends Aggregator {
    private static final long serialVersionUID = 8649552819877230509L;
    private CustomAggFunction<Object> aggFunc;

    public CustomizedAggregator(CustomAggFunction<Object> aggFunc) {
        super(aggFunc.getFunName());
        this.aggFunc = aggFunc;
    }

    @Override
    public Object appendValue(Object source, Object value) throws AlgoException {
        if (source == null) {
            source = this.aggFunc.newAggValue();
        }
        return this.aggFunc.addValue(source, value);
    }

    @Override
    public Object appendAggregator(Object source, Object source2) throws AlgoException {
        if (source == null) {
            return source2;
        }
        if (source2 == null) {
            return source;
        }
        return this.aggFunc.combineAggValue(source, source2);
    }

    @Override
    public Object getValue(Object source) throws AlgoException {
        if (source == null) {
            return source;
        }
        return this.aggFunc.getResult(source);
    }

    @Override
    public boolean valueIsCompounded() {
        return false;
    }
}

