/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.columnbased.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.algo.util.columnbased.impl.SimpleBitmap;
import kd.bos.algo.util.columnbased.impl.Vector;

public class BitmapVector
implements Vector,
Serializable {
    private static final long serialVersionUID = -7731971219180624754L;
    private static Object nullObject = new Object();
    private ArrayList<Object> values = new ArrayList(16);
    private HashMap<Object, Integer> index = new HashMap();
    SimpleBitmap bitmap = new SimpleBitmap();
    private int size;

    public BitmapVector() {
    }

    public BitmapVector(Object[] rows) {
        for (int i = 0; i < rows.length; ++i) {
            this.append(rows[i]);
        }
    }

    public BitmapVector(Iterator<Object> iter) {
        while (iter.hasNext()) {
            this.append(iter.next());
        }
    }

    public BitmapVector(Collection<Object> collection) {
        Iterator<Object> iter = collection.iterator();
        while (iter.hasNext()) {
            this.append(iter.next());
        }
    }

    @Override
    public void append(Object o) {
        Integer idx;
        if (o == null) {
            o = nullObject;
        }
        if ((idx = this.index.get(o)) == null) {
            this.bitmap.set(this.values.size(), this.size);
            this.index.put(o, this.values.size());
            this.values.add(o);
        } else {
            this.bitmap.set(idx, this.size);
        }
        ++this.size;
    }

    @Override
    public void set(int row, Object o) {
        if (row >= this.size) {
            throw new IllegalArgumentException("row not found: " + row);
        }
        for (int i = 0; i < this.bitmap.getColumnCount(); ++i) {
            this.bitmap.clear(i, row);
        }
        if (o != null) {
            Integer idx = this.index.get(o);
            if (idx == null) {
                this.bitmap.set(this.values.size(), row);
                this.index.put(o, this.values.size());
                this.values.add(o);
            } else {
                this.bitmap.set(idx, row);
            }
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public Object get(int row) {
        Object ret = null;
        for (int i = 0; i < this.bitmap.getColumnCount(); ++i) {
            if (!this.bitmap.get(i, row)) continue;
            ret = this.values.get(i);
            return ret == nullObject ? null : ret;
        }
        return null;
    }

    @Override
    public int getCardinality() {
        return this.values.size();
    }

    @Override
    public double getFactor() {
        return 1.0 * (double)this.values.size() / (double)this.size;
    }

    @Override
    public void finishAppend() {
        this.bitmap.compact();
        this.index = null;
    }

    @Override
    public Iterator<Object> iterator() {
        return new MyIterator();
    }

    private class MyIterator
    implements Iterator<Object> {
        int pos = 0;

        private MyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < BitmapVector.this.size;
        }

        @Override
        public Object next() {
            Object t = BitmapVector.this.get(this.pos);
            ++this.pos;
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

