/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.columnbased.impl;

import java.io.Serializable;
import kd.bos.algo.util.columnbased.ColumnBasedGrid;
import kd.bos.algo.util.columnbased.impl.BitmapVector;
import kd.bos.algo.util.columnbased.impl.Vector;
import kd.bos.algo.util.columnbased.impl.VectorConverter;

public class ColumnBasedGridImpl
implements ColumnBasedGrid,
Serializable {
    private static final long serialVersionUID = 3442061057461865383L;
    private Vector[] vectors;
    private int rowCount = 0;
    private int columnCount;

    public ColumnBasedGridImpl(int columnCount) {
        this.columnCount = columnCount;
        this.vectors = new Vector[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            this.vectors[i] = new BitmapVector();
        }
    }

    public ColumnBasedGridImpl(Vector[] vectors) {
        this.vectors = vectors;
        int n = vectors.length;
        for (int i = 0; i < n; ++i) {
            int size = vectors[i].getSize();
            if (this.rowCount >= size) continue;
            this.rowCount = size;
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    public Vector getVector(int columnIndex) {
        return this.vectors[columnIndex];
    }

    @Override
    public void appendRow(Object[] objects) {
        int i;
        assert (this.columnCount == objects.length);
        for (i = 0; i < this.columnCount; ++i) {
            this.vectors[i].append(objects[i]);
        }
        ++this.rowCount;
        if (this.rowCount % 100 == 0) {
            for (i = 0; i < this.columnCount; ++i) {
                this.vectors[i] = VectorConverter.convert(this.vectors[i]);
            }
        }
    }

    @Override
    public void setCell(int columnIndex, int rowIndex, Object value) {
        this.vectors[columnIndex].set(rowIndex, value);
    }

    @Override
    public void toRowArray(int rowIndex, Object[] rowValues) {
        int n = this.vectors.length;
        for (int i = 0; i < n; ++i) {
            rowValues[i] = this.vectors[i].get(rowIndex);
        }
    }

    @Override
    public Object getCell(int columnIndex, int rowIndex) {
        return this.vectors[columnIndex].get(rowIndex);
    }

    public void finishAppend() {
        for (Vector vector : this.vectors) {
            vector.finishAppend();
        }
    }
}

