/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.columnbased.impl;

import java.io.Serializable;
import java.util.ArrayList;
import kd.bos.algo.util.bitset.BitSetFactory;
import kd.bos.algo.util.bitset.IntBitSet;
import kd.bos.algo.util.columnbased.impl.Bitmap;

public final class SimpleBitmap
implements Bitmap,
Serializable {
    private static final long serialVersionUID = 4052041633000507167L;
    private ArrayList<IntBitSet> bitsets = new ArrayList();
    private int rowCount = 0;

    private IntBitSet newBitSet() {
        return BitSetFactory.createInt();
    }

    @Override
    public void set(int column, int row) {
        if (this.bitsets.size() <= column) {
            for (int i = this.bitsets.size(); i < column - 1; ++i) {
                this.bitsets.add(this.newBitSet());
            }
            IntBitSet bitset = this.newBitSet();
            bitset.set(row);
            this.bitsets.add(bitset);
        } else {
            this.bitsets.get(column).set(row);
        }
        if (row > this.rowCount) {
            this.rowCount = row;
        }
    }

    @Override
    public void clear(int column, int row) {
        if (this.bitsets.size() < column) {
            for (int i = this.bitsets.size(); i < column - 1; ++i) {
                this.bitsets.add(this.newBitSet());
            }
            IntBitSet bitset = this.newBitSet();
            bitset.remove(row);
            this.bitsets.add(bitset);
        } else {
            this.bitsets.get(column).remove(row);
        }
        if (row > this.rowCount) {
            this.rowCount = row;
        }
    }

    @Override
    public boolean get(int column, int row) {
        if (this.bitsets.size() < column) {
            return false;
        }
        return this.bitsets.get(column).get(row);
    }

    @Override
    public int getColumnCount() {
        return this.bitsets.size();
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public void compact() {
    }
}

