/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.io.disk;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.util.io.disk.AsynchronousFileIOChannel;
import kd.bos.algo.util.io.disk.BlockChannelReader;
import kd.bos.algo.util.io.disk.FileIOChannel;
import kd.bos.algo.util.io.disk.QueuingCallback;
import kd.bos.algo.util.io.disk.ReadRequest;
import kd.bos.algo.util.io.disk.RequestQueue;
import kd.bos.algo.util.io.disk.SeekRequest;
import kd.bos.algo.util.io.disk.SegmentReadRequest;
import kd.bos.algo.util.io.disk.compress.CompressIOFactroy;
import kd.bos.algo.util.io.disk.compress.CompressReader;
import kd.bos.algo.util.memory.MemorySegment;

public class AsynchronousBlockReader
extends AsynchronousFileIOChannel<MemorySegment, ReadRequest>
implements BlockChannelReader<MemorySegment> {
    private final LinkedBlockingQueue<MemorySegment> returnSegments;
    private final CompressReader reader;

    protected AsynchronousBlockReader(FileIOChannel.ID channelID, RequestQueue<ReadRequest> requestQueue, LinkedBlockingQueue<MemorySegment> returnSegments) throws IOException {
        super(channelID, requestQueue, new QueuingCallback<MemorySegment>(returnSegments), false);
        this.returnSegments = returnSegments;
        this.reader = CompressIOFactroy.getReader(compressType, this.getNioFileChannel());
    }

    @Override
    public void readBlock(MemorySegment segment) throws IOException {
        this.addRequest(new SegmentReadRequest(this, segment, this.reader));
    }

    @Override
    public void seekToPosition(long position) throws IOException {
        this.requestQueue.add(new SeekRequest(this, position));
    }

    @Override
    public MemorySegment getNextReturnedBlock() throws IOException {
        try {
            while (true) {
                MemorySegment next;
                if ((next = this.returnSegments.poll(1000L, TimeUnit.MILLISECONDS)) != null) {
                    return next;
                }
                if (this.closed) {
                    throw new IOException("The reader has been asynchronously closed.");
                }
                this.checkErroneous();
            }
        }
        catch (InterruptedException iex) {
            throw new IOException("Reader was interrupted while waiting for the next returning segment.");
        }
    }

    @Override
    public LinkedBlockingQueue<MemorySegment> getReturnQueue() {
        return this.returnSegments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                while (this.requestsNotReturned.get() > 0) {
                    try {
                        this.closeLock.wait(1000L);
                        this.checkErroneous();
                    }
                    catch (InterruptedException iex) {
                        throw new IOException("Closing of asynchronous file channel was interrupted.");
                    }
                }
                this.checkErroneous();
            }
            finally {
                if (!this.reader.isClosed()) {
                    this.reader.close();
                }
                if (this.fileChannel.isOpen()) {
                    this.fileChannel.close();
                }
            }
        }
    }
}

