/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.io.disk;

import java.io.IOException;
import kd.bos.algo.util.io.disk.AsynchronousFileIOChannel;
import kd.bos.algo.util.io.disk.BlockChannelWriterWithCallback;
import kd.bos.algo.util.io.disk.FileIOChannel;
import kd.bos.algo.util.io.disk.RequestDoneCallback;
import kd.bos.algo.util.io.disk.RequestQueue;
import kd.bos.algo.util.io.disk.SegmentWriteRequest;
import kd.bos.algo.util.io.disk.WriteRequest;
import kd.bos.algo.util.io.disk.compress.CompressIOFactroy;
import kd.bos.algo.util.io.disk.compress.CompressWriter;
import kd.bos.algo.util.memory.MemorySegment;

public class AsynchronousBlockWriterWithCallback
extends AsynchronousFileIOChannel<MemorySegment, WriteRequest>
implements BlockChannelWriterWithCallback<MemorySegment> {
    private CompressWriter writer = CompressIOFactroy.getWriter(compressType, this.getNioFileChannel());

    protected AsynchronousBlockWriterWithCallback(FileIOChannel.ID channelID, RequestQueue<WriteRequest> requestQueue, RequestDoneCallback<MemorySegment> callback) throws IOException {
        super(channelID, requestQueue, callback, true);
    }

    @Override
    public void writeBlock(MemorySegment segment) throws IOException {
        this.addRequest(new SegmentWriteRequest(this, segment, this.writer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                while (this.requestsNotReturned.get() > 0) {
                    try {
                        this.closeLock.wait(1000L);
                        this.checkErroneous();
                    }
                    catch (InterruptedException iex) {
                        throw new IOException("Closing of asynchronous file channel was interrupted.");
                    }
                }
                this.checkErroneous();
            }
            finally {
                if (!this.writer.isClosed()) {
                    this.writer.close();
                }
                if (this.fileChannel.isOpen()) {
                    this.fileChannel.close();
                }
            }
        }
    }
}

