/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.io.disk;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.util.event.NotificationListener;
import kd.bos.algo.util.io.disk.AbstractFileIOChannel;
import kd.bos.algo.util.io.disk.FileIOChannel;
import kd.bos.algo.util.io.disk.IORequest;
import kd.bos.algo.util.io.disk.RequestDoneCallback;
import kd.bos.algo.util.io.disk.RequestQueue;

public abstract class AsynchronousFileIOChannel<T, R extends IORequest>
extends AbstractFileIOChannel {
    private final Object listenerLock = new Object();
    protected final Object closeLock = new Object();
    protected final RequestQueue<R> requestQueue;
    protected final AtomicInteger requestsNotReturned = new AtomicInteger(0);
    protected final RequestDoneCallback<T> resultHandler;
    protected volatile IOException exception;
    protected volatile boolean closed;
    protected static final String compressType = AlgoConfiguration.IO_TMP_DIRS_COMPRESS.getString();
    private NotificationListener allRequestsProcessedListener;

    protected AsynchronousFileIOChannel(FileIOChannel.ID channelID, RequestQueue<R> requestQueue, RequestDoneCallback<T> callback, boolean writeEnabled) throws IOException {
        super(channelID, writeEnabled);
        this.requestQueue = (RequestQueue)Preconditions.checkNotNull(requestQueue);
        this.resultHandler = (RequestDoneCallback)Preconditions.checkNotNull(callback);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                while (this.requestsNotReturned.get() > 0) {
                    try {
                        this.closeLock.wait(1000L);
                        this.checkErroneous();
                    }
                    catch (InterruptedException iex) {
                        throw new IOException("Closing of asynchronous file channel was interrupted.");
                    }
                }
                this.checkErroneous();
            }
            finally {
                if (this.fileChannel.isOpen()) {
                    this.fileChannel.close();
                }
            }
        }
    }

    @Override
    public void closeAndDelete() throws IOException {
        try {
            this.close();
        }
        finally {
            this.deleteChannel();
        }
    }

    public final void checkErroneous() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void handleProcessedBuffer(T buffer, IOException ex) {
        if (buffer == null) {
            return;
        }
        try {
            if (ex != null && this.exception == null) {
                this.exception = ex;
                this.resultHandler.requestFailed(buffer, ex);
            } else {
                this.resultHandler.requestSuccessful(buffer);
            }
        }
        finally {
            NotificationListener listener = null;
            Object object = this.closeLock;
            synchronized (object) {
                if (this.requestsNotReturned.decrementAndGet() == 0) {
                    if (this.closed) {
                        this.closeLock.notifyAll();
                    }
                    Object object2 = this.listenerLock;
                    synchronized (object2) {
                        listener = this.allRequestsProcessedListener;
                        this.allRequestsProcessedListener = null;
                    }
                }
            }
            if (listener != null) {
                listener.onNotification();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addRequest(R request) throws IOException {
        this.checkErroneous();
        this.requestsNotReturned.incrementAndGet();
        if (this.closed || this.requestQueue.isClosed()) {
            NotificationListener listener;
            this.requestsNotReturned.decrementAndGet();
            Object object = this.listenerLock;
            synchronized (object) {
                listener = this.allRequestsProcessedListener;
                this.allRequestsProcessedListener = null;
            }
            if (listener != null) {
                listener.onNotification();
            }
            throw new IOException("I/O channel already closed. Could not fulfill: " + request);
        }
        this.requestQueue.add(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean registerAllRequestsProcessedListener(NotificationListener listener) throws IOException {
        Preconditions.checkNotNull((Object)listener);
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.allRequestsProcessedListener == null) {
                if (this.requestsNotReturned.get() == 0) {
                    return false;
                }
                this.allRequestsProcessedListener = listener;
                return true;
            }
        }
        throw new IllegalStateException("Already subscribed.");
    }
}

