/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.io.disk;

import com.google.common.base.Preconditions;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import kd.bos.algo.AlgoException;
import kd.bos.algo.util.ObjectRef;
import kd.bos.algo.util.io.ExceptionUtils;
import kd.bos.algo.util.io.disk.BlockChannelReader;
import kd.bos.algo.util.io.disk.ChannelReaderInputView;
import kd.bos.algo.util.memory.MemorySegment;

public class HeaderlessChannelReaderInputView
extends ChannelReaderInputView {
    private final ObjectRef<Exception> closedRef;
    private int numBlocksRemaining;
    private final int lastBlockBytes;
    private long offset = 0L;
    private boolean isFirstBlock;

    public HeaderlessChannelReaderInputView(BlockChannelReader<MemorySegment> reader, List<MemorySegment> memory, int numBlocks, int numBytesInLastBlock, boolean waitForFirstBlock, long offset, ObjectRef<Exception> closedRef) throws IOException {
        super(reader, memory, numBlocks, 0, false);
        this.numBlocksRemaining = numBlocks;
        this.lastBlockBytes = numBytesInLastBlock;
        this.closedRef = closedRef;
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"`offset` can't be negative!");
        this.offset = offset;
        if (waitForFirstBlock) {
            this.advance();
        }
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current) throws IOException {
        if (this.closedRef != null && this.closedRef.get() != null) {
            throw new AlgoException("View has been closed, close stack is:" + ExceptionUtils.stringifyException(this.closedRef.get()));
        }
        if (this.numBlocksRemaining <= 0) {
            this.reader.close();
            throw new EOFException();
        }
        if (current != null) {
            this.sendReadRequest(current);
        }
        this.isFirstBlock = current == null;
        --this.numBlocksRemaining;
        return (MemorySegment)this.reader.getNextReturnedBlock();
    }

    @Override
    public void advance() throws IOException {
        this.doAdvance();
        if (this.isFirstBlock && this.offset > 0L) {
            this.seekInput(this.getCurrentSegment(), (int)this.offset, this.getCurrentSegmentLimit());
        }
    }

    @Override
    protected int getLimitForSegment(MemorySegment segment) {
        return this.numBlocksRemaining > 0 ? segment.size() : this.lastBlockBytes;
    }
}

