/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.io.disk;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.algo.util.io.disk.BlockChannelReader;
import kd.bos.algo.util.io.disk.BlockChannelWriter;
import kd.bos.algo.util.io.disk.BlockChannelWriterWithCallback;
import kd.bos.algo.util.io.disk.FileChannelManager;
import kd.bos.algo.util.io.disk.FileChannelManagerImpl;
import kd.bos.algo.util.io.disk.FileIOChannel;
import kd.bos.algo.util.io.disk.RequestDoneCallback;
import kd.bos.algo.util.memory.MemorySegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IOManager
implements AutoCloseable {
    protected static final Logger LOG = LoggerFactory.getLogger(IOManager.class);
    private static final String DIR_NAME_PREFIX = "io";
    private final FileChannelManager fileChannelManager;

    protected IOManager(String[] tempDirs) {
        this.fileChannelManager = new FileChannelManagerImpl((String[])Preconditions.checkNotNull((Object)tempDirs), DIR_NAME_PREFIX);
    }

    @Override
    public void close() throws Exception {
        this.fileChannelManager.close();
    }

    public FileIOChannel.ID createChannel() {
        return this.fileChannelManager.createChannel();
    }

    public FileIOChannel.Enumerator createChannelEnumerator() {
        return this.fileChannelManager.createChannelEnumerator();
    }

    public static void deleteChannel(FileIOChannel.ID channel) {
        if (channel != null && channel.getPathFile().exists() && !channel.getPathFile().delete()) {
            LOG.warn("IOManager failed to delete temporary file {}", (Object)channel.getPath());
        }
    }

    public File[] getSpillingDirectories() {
        return this.fileChannelManager.getPaths();
    }

    public String[] getSpillingDirectoriesPaths() {
        File[] paths = this.fileChannelManager.getPaths();
        String[] strings = new String[paths.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = paths[i].getAbsolutePath();
        }
        return strings;
    }

    public BlockChannelWriter<MemorySegment> createBlockChannelWriter(FileIOChannel.ID channelID) throws IOException {
        return this.createBlockChannelWriter(channelID, new LinkedBlockingQueue<MemorySegment>());
    }

    public abstract BlockChannelWriter<MemorySegment> createBlockChannelWriter(FileIOChannel.ID var1, LinkedBlockingQueue<MemorySegment> var2) throws IOException;

    public abstract BlockChannelWriterWithCallback<MemorySegment> createBlockChannelWriter(FileIOChannel.ID var1, RequestDoneCallback<MemorySegment> var2) throws IOException;

    public BlockChannelReader<MemorySegment> createBlockChannelReader(FileIOChannel.ID channelID) throws IOException {
        return this.createBlockChannelReader(channelID, new LinkedBlockingQueue<MemorySegment>());
    }

    public abstract BlockChannelReader<MemorySegment> createBlockChannelReader(FileIOChannel.ID var1, LinkedBlockingQueue<MemorySegment> var2) throws IOException;
}

