/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.io.disk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import kd.bos.algo.util.io.disk.AsynchronousFileIOChannel;
import kd.bos.algo.util.io.disk.ReadRequest;
import kd.bos.algo.util.io.disk.compress.CompressReader;
import kd.bos.algo.util.memory.MemorySegment;

final class SegmentReadRequest
implements ReadRequest {
    private final AsynchronousFileIOChannel<MemorySegment, ReadRequest> channel;
    private final MemorySegment segment;
    private CompressReader reader;

    protected SegmentReadRequest(AsynchronousFileIOChannel<MemorySegment, ReadRequest> targetChannel, MemorySegment segment, CompressReader reader) {
        if (segment == null) {
            throw new NullPointerException("Illegal read request with null memory segment.");
        }
        this.channel = targetChannel;
        this.segment = segment;
        this.reader = reader;
    }

    @Override
    public void read() throws IOException {
        FileChannel c = this.channel.fileChannel;
        if (c.size() - c.position() > 0L) {
            try {
                this.segment.processAsByteBuffer(byteBuffer -> this.reader.read((ByteBuffer)byteBuffer, this.segment));
            }
            catch (NullPointerException npex) {
                throw new IOException("Memory segment has been released.");
            }
        }
    }

    @Override
    public void requestDone(IOException ioex) {
        this.channel.handleProcessedBuffer(this.segment, ioex);
    }
}

