/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.io.disk;

import java.io.IOException;
import java.nio.ByteBuffer;
import kd.bos.algo.util.io.disk.AsynchronousFileIOChannel;
import kd.bos.algo.util.io.disk.WriteRequest;
import kd.bos.algo.util.io.disk.compress.CompressWriter;
import kd.bos.algo.util.memory.MemorySegment;

final class SegmentWriteRequest
implements WriteRequest {
    private final AsynchronousFileIOChannel<MemorySegment, WriteRequest> channel;
    private final MemorySegment segment;
    private final CompressWriter writer;

    protected SegmentWriteRequest(AsynchronousFileIOChannel<MemorySegment, WriteRequest> targetChannel, MemorySegment segment, CompressWriter writer) {
        this.channel = targetChannel;
        this.segment = segment;
        this.writer = writer;
    }

    @Override
    public void write() throws IOException {
        try {
            this.segment.processAsByteBuffer(buffer -> this.writer.write((ByteBuffer)buffer));
        }
        catch (NullPointerException npex) {
            throw new IOException("Memory segment has been released.");
        }
    }

    @Override
    public void requestDone(IOException ioex) {
        this.channel.handleProcessedBuffer(this.segment, ioex);
    }
}

