/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.io.disk.compress;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.zip.GZIPInputStream;
import kd.bos.algo.util.io.disk.compress.CompressReader;
import kd.bos.algo.util.memory.MemorySegment;

public class GzipReader
implements CompressReader {
    private GZIPInputStream gis;
    private ByteArrayOutputStream bos;
    private boolean closed;

    public GzipReader(FileChannel fileChannel) {
        try {
            this.gis = new GZIPInputStream(Channels.newInputStream(fileChannel));
            this.bos = new ByteArrayOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] read(ByteBuffer buffer, MemorySegment segment) {
        try {
            int remaining = buffer.remaining();
            int bytesRead = 0;
            int count = 1;
            byte[] byteArray = new byte[remaining];
            while (!this.closed && (bytesRead = this.gis.read()) != -1) {
                byteArray[count - 1] = (byte)bytesRead;
                if (count >= remaining) break;
                ++count;
            }
            if (count >= remaining) {
                buffer.put(byteArray);
            } else {
                buffer.put(byteArray, 0, count);
            }
            return null;
        }
        catch (Exception var6) {
            throw new RuntimeException("read file error ", var6);
        }
    }

    @Override
    public void close() {
        try {
            if (this.bos != null) {
                this.bos.close();
            }
            if (this.gis != null) {
                this.gis.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

