/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.io.disk.compress;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.zip.GZIPOutputStream;
import kd.bos.algo.util.io.disk.compress.CompressWriter;

public class GzipWriter
implements CompressWriter {
    private GZIPOutputStream gos;
    private boolean closed;

    public GzipWriter(FileChannel fileChannel) {
        try {
            this.gos = new GZIPOutputStream(Channels.newOutputStream(fileChannel));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int write(ByteBuffer buffer) {
        try {
            if (!this.closed && buffer.hasRemaining()) {
                byte[] bufferByte = new byte[buffer.remaining()];
                buffer.get(bufferByte);
                this.gos.write(bufferByte);
                this.gos.flush();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("remaining:" + buffer.remaining(), e);
        }
        return 1;
    }

    @Override
    public void close() {
        if (this.gos != null) {
            try {
                this.gos.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

