/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import kd.bos.algo.util.memory.DataInputView;
import kd.bos.algo.util.memory.DataOutputView;
import kd.bos.algo.util.types.TypeSerializer;

public final class StringSerializer
extends TypeSerializer<String> {
    public static final StringSerializer INSTANCE = new StringSerializer();
    private static final int HIGH_BIT = 128;
    private static final int HIGH_BIT14 = 16384;
    private static final int HIGH_BIT21 = 0x200000;
    private static final int HIGH_BIT28 = 0x10000000;
    private static final int SHORT_STRING_MAX_LENGTH = 2048;
    private static final ThreadLocal<char[]> charBuffer = ThreadLocal.withInitial(() -> new char[2048]);

    @Override
    public void serialize(String record, DataOutputView target) throws IOException {
        StringSerializer.writeString(record, target);
    }

    @Override
    public String deserialize(DataInputView source) throws IOException {
        return StringSerializer.readString(source);
    }

    public static String readString(DataInput in) throws IOException {
        int len = in.readUnsignedByte();
        if (len == 0) {
            return null;
        }
        if (len >= 128) {
            int curr;
            int shift = 7;
            len &= 0x7F;
            while ((curr = in.readUnsignedByte()) >= 128) {
                len |= (curr & 0x7F) << shift;
                shift += 7;
            }
            len |= curr << shift;
        }
        char[] data = --len > 2048 ? new char[len] : charBuffer.get();
        for (int i = 0; i < len; ++i) {
            int c = in.readUnsignedByte();
            if (c >= 128) {
                int curr;
                int shift = 7;
                c &= 0x7F;
                while ((curr = in.readUnsignedByte()) >= 128) {
                    c |= (curr & 0x7F) << shift;
                    shift += 7;
                }
                c |= curr << shift;
            }
            data[i] = (char)c;
        }
        return new String(data, 0, len);
    }

    public static final void writeString(CharSequence cs, DataOutput out) throws IOException {
        if (cs != null) {
            int strlen = cs.length();
            int lenToWrite = strlen + 1;
            if (lenToWrite < 0) {
                throw new IllegalArgumentException("CharSequence is too long.");
            }
            if (lenToWrite < 128) {
                out.write((byte)lenToWrite);
            } else if (lenToWrite < 16384) {
                out.write(lenToWrite | 0x80);
                out.write(lenToWrite >>> 7);
            } else if (lenToWrite < 0x200000) {
                out.write(lenToWrite | 0x80);
                out.write(lenToWrite >>> 7 | 0x80);
                out.write(lenToWrite >>> 14);
            } else if (lenToWrite < 0x10000000) {
                out.write(lenToWrite | 0x80);
                out.write(lenToWrite >>> 7 | 0x80);
                out.write(lenToWrite >>> 14 | 0x80);
                out.write(lenToWrite >>> 21);
            } else {
                out.write(lenToWrite | 0x80);
                out.write(lenToWrite >>> 7 | 0x80);
                out.write(lenToWrite >>> 14 | 0x80);
                out.write(lenToWrite >>> 21 | 0x80);
                out.write(lenToWrite >>> 28);
            }
            for (int i = 0; i < strlen; ++i) {
                char c = cs.charAt(i);
                if (c < '\u0080') {
                    out.write(c);
                    continue;
                }
                if (c < '\u4000') {
                    out.write(c | 0x80);
                    out.write(c >>> 7);
                    continue;
                }
                out.write(c | 0x80);
                out.write(c >>> 7 | 0x80);
                out.write(c >>> 14);
            }
        } else {
            out.write(0);
        }
    }
}

