/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.core;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algox.CoGroupDataSetX;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.GroupCombineFunction;
import kd.bos.algox.GroupCombineReduceFunction;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.Grouper;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.algox.core.AddFieldsDataSetX;
import kd.bos.algox.core.AggField;
import kd.bos.algox.core.AggregatorDataSetX;
import kd.bos.algox.core.DataSinkX;
import kd.bos.algox.core.DistinctDataSetX;
import kd.bos.algox.core.FilterDataSetX;
import kd.bos.algox.core.FlatMapDataSetX;
import kd.bos.algox.core.GroupCombineDataSetX;
import kd.bos.algox.core.GroupCombineReduceDataSetX;
import kd.bos.algox.core.GroupReduceDataSetX;
import kd.bos.algox.core.JobContext;
import kd.bos.algox.core.MapDataSetX;
import kd.bos.algox.core.PartitionByHashDataSetX;
import kd.bos.algox.core.RemoveFieldsDataSetX;
import kd.bos.algox.core.SelectDataSetX;
import kd.bos.algox.core.SortGlobalDataSetX;
import kd.bos.algox.core.TopDataSetX;
import kd.bos.algox.core.UnionDataSetX;
import kd.bos.algox.util.AlgoXUtil;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public abstract class AbstractDataSetX
implements DataSetX {
    private final JobContext context;
    private RowMeta rowMeta;
    private ArrayList<DataSetX> sourceList = new ArrayList(2);
    protected String location;
    private boolean singleParallel;

    public AbstractDataSetX(JobContext context, DataSetX source) {
        this.context = context;
        if (source != null) {
            this.sourceList.add(source);
        }
        this.location = AlgoXUtil.getCallLocationName(5);
    }

    public AbstractDataSetX(JobContext context, DataSetX source1, DataSetX source2) {
        this.context = context;
        this.sourceList.add(source1);
        this.sourceList.add(source2);
        this.location = AlgoXUtil.getCallLocationName(5);
    }

    public String getLocation() {
        return this.location;
    }

    public DataSetX getSource() {
        return this.sourceList.get(0);
    }

    public List<DataSetX> getSources() {
        return ImmutableList.copyOf(this.sourceList);
    }

    @Override
    public RowMeta getRowMeta() {
        if (this.rowMeta == null) {
            this.rowMeta = this.createRowMeta();
        }
        if (this.rowMeta == null) {
            throw new AlgoException("Can't createRowMeta");
        }
        return this.rowMeta;
    }

    protected abstract RowMeta createRowMeta();

    @Override
    public DataSetX select(String ... fields) {
        return new SelectDataSetX(this.context, (DataSetX)this, fields);
    }

    @Override
    public DataSetX filter(String expr) {
        return this.filter(expr, null);
    }

    @Override
    public DataSetX filter(String expr, Map<String, Object> params) {
        return new FilterDataSetX(this.context, this, expr, params);
    }

    @Override
    public DataSetX filter(FilterFunction func) {
        return new FilterDataSetX(this.context, (DataSetX)this, func);
    }

    @Override
    public DataSetX map(MapFunction func) {
        return new MapDataSetX(this.context, (DataSetX)this, func);
    }

    @Override
    public DataSetX flatMap(FlatMapFunction func) {
        return new FlatMapDataSetX(this.context, (DataSetX)this, func);
    }

    @Override
    public DataSetX union(DataSetX another) {
        return new UnionDataSetX(this.context, this, another);
    }

    @Override
    public DataSetX top(int n) {
        return new TopDataSetX(this.context, (DataSetX)this, n);
    }

    @Override
    public DataSetX distinct(String ... fields) {
        return new DistinctDataSetX(this.context, (DataSetX)this, fields);
    }

    @Override
    public DataSetX partitionByHash(String ... fields) {
        return new PartitionByHashDataSetX(this.context, (DataSetX)this, fields);
    }

    @Override
    public Grouper groupBy(String ... fields) {
        return new Grouper(this.context, this, fields);
    }

    @Override
    public DataSetX orderBy(String ... fields) {
        return new SortGlobalDataSetX(this.context, (DataSetX)this, fields);
    }

    @Override
    public DataSetX reduceGroup(GroupReduceFunction func) {
        return new GroupReduceDataSetX(this.context, this, null, func);
    }

    @Override
    public DataSetX combineGroup(GroupCombineFunction func) {
        return new GroupCombineDataSetX(this.context, this, null, func);
    }

    @Override
    public DataSetX combineReduceGroup(GroupCombineReduceFunction func) {
        return new GroupCombineReduceDataSetX(this.context, this, null, func);
    }

    @Override
    public CoGroupDataSetX coGroup(DataSetX dataSet, CoGroupFunction func) {
        return new CoGroupDataSetX(this.context, this, dataSet, func);
    }

    @Override
    public JoinDataSetX join(DataSetX right) {
        return new JoinDataSetX(this.context, this, right, JoinType.INNER);
    }

    @Override
    public JoinDataSetX leftJoin(DataSetX right) {
        return new JoinDataSetX(this.context, this, right, JoinType.LEFT);
    }

    @Override
    public JoinDataSetX rightJoin(DataSetX right) {
        return new JoinDataSetX(this.context, this, right, JoinType.RIGHT);
    }

    @Override
    public JoinDataSetX fullJoin(DataSetX right) {
        return new JoinDataSetX(this.context, this, right, JoinType.FULL);
    }

    @Override
    public DataSetX addFields(Field[] fields, Object[] values) {
        return new AddFieldsDataSetX(this.context, this, fields, values);
    }

    @Override
    public DataSetX removeFields(String ... fields) {
        return new RemoveFieldsDataSetX(this.context, (DataSetX)this, fields);
    }

    @Override
    public void output(Output output) {
        DataSinkX sink = new DataSinkX(this, output);
        this.context.registerDataSink(sink);
    }

    @Override
    public AggregatorDataSetX sum(String field) {
        return this.sum(field, null);
    }

    @Override
    public AggregatorDataSetX max(String field) {
        return this.max(field, null);
    }

    @Override
    public AggregatorDataSetX min(String field) {
        return this.min(field, null);
    }

    @Override
    public AggregatorDataSetX count(String field) {
        return this.count(field, null);
    }

    @Override
    public AggregatorDataSetX sum(String field, String alias) {
        return this.aggregate(0, field, alias);
    }

    @Override
    public AggregatorDataSetX max(String field, String alias) {
        return this.aggregate(2, field, alias);
    }

    @Override
    public AggregatorDataSetX min(String field, String alias) {
        return this.aggregate(3, field, alias);
    }

    @Override
    public AggregatorDataSetX count(String field, String alias) {
        return this.aggregate(1, field, alias);
    }

    protected AggregatorDataSetX aggregate(int func, String field, String alias) {
        return new AggregatorDataSetX(this.context, this, null, new AggField(func, field, alias));
    }

    @Override
    public void setSingleParallel(boolean value) {
        this.singleParallel = value;
    }

    @Override
    public boolean isSingleParallel() {
        return this.singleParallel;
    }
}

