/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.core;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algox.cluster.ClusterFactory;
import kd.bos.algox.core.DataSinkX;
import kd.bos.util.ConfigurationUtil;
import org.apache.commons.lang.StringUtils;

public class JobContext
implements Serializable {
    private static final long serialVersionUID = -8226824357413890218L;
    public static final String KEY_DISABLELOCALMODE = "disableLocalMode";
    public static final String KEY_REQUESTCONTEXT = "requestContext";
    private String jobName;
    private String title;
    private String region;
    private boolean disableLocalModel;
    private transient List<DataSinkX> sinks = new ArrayList<DataSinkX>();
    private String readWriteMode;
    private int parallelism = ClusterFactory.getFactory().getClusterClient().isLocal() ? ConfigurationUtil.getInteger((String)"algox.client.job.parallelism", (Integer)3).intValue() : ConfigurationUtil.getInteger((String)"algox.client.job.parallelism", (Integer)4).intValue();

    public void registerDataSink(DataSinkX dataSink) {
        this.sinks.add(dataSink);
    }

    public List<DataSinkX> getDataSinks() {
        return ImmutableList.copyOf(this.sinks);
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public void clear() {
        this.sinks.clear();
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getRegion() {
        if (StringUtils.isEmpty((String)this.region)) {
            return "default";
        }
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public boolean isDisableLocalModel() {
        return this.disableLocalModel;
    }

    public void disableLocalModel() {
        this.disableLocalModel = true;
    }

    public String getReadWriteMode() {
        return this.readWriteMode;
    }

    public void setReadWriteMode(String readWriteMode) {
        this.readWriteMode = readWriteMode;
    }
}

