/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.region;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

class MappingParser {
    private static final ObjectMapper mapper = new ObjectMapper();

    MappingParser() {
    }

    public Mapping parse(String text) throws KDException {
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        try {
            return (Mapping)mapper.readValue(text, (TypeReference)new TypeReference<Mapping>(){});
        }
        catch (JsonProcessingException e) {
            throw new KDException(BosErrorCode.jSONParsing, "Parse AlgoX region mapping config error. " + e.getMessage(), (Throwable)e);
        }
    }

    public static class MappingItem {
        private String name;
        private String clusterRegion;

        public MappingItem() {
        }

        public MappingItem(String name, String clusterRegion) {
            this.name = name;
            this.clusterRegion = clusterRegion;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getClusterRegion() {
            return this.clusterRegion;
        }

        public void setClusterRegion(String clusterRegion) {
            this.clusterRegion = clusterRegion;
        }
    }

    public static class Mapping {
        private List<MappingItem> nameMapping;
        private List<MappingItem> regionMapping;

        public Mapping() {
        }

        public Mapping(List<MappingItem> nameMapping, List<MappingItem> regionMapping) {
            this.nameMapping = nameMapping;
            this.regionMapping = regionMapping;
        }

        public List<MappingItem> getNameMapping() {
            return this.nameMapping;
        }

        public void setNameMapping(List<MappingItem> nameMapping) {
            this.nameMapping = nameMapping;
        }

        public List<MappingItem> getRegionMapping() {
            return this.regionMapping;
        }

        public void setRegionMapping(List<MappingItem> regionMapping) {
            this.regionMapping = regionMapping;
        }
    }
}

