/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ReflectCallUtil {
    private static final String CLASSNAME_THREADPOOLS = "kd.bos.threads.ThreadPools";
    private static Log logger = LogFactory.getLog(ReflectCallUtil.class);
    private static Class<?> threadPoolsC = null;
    private static Method executeOnceIncludeRequestContextM = null;

    private ReflectCallUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void executeOnceIncludeRequestContext(String name, Runnable runnable) {
        try {
            executeOnceIncludeRequestContextM.invoke(threadPoolsC, name, runnable);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            String errorMsg = "invoke kd.bos.threads.ThreadPools.executeOnceIncludeRequestContext() errror:";
            logger.error(errorMsg, (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.methodInvocation, new Object[]{errorMsg});
        }
    }

    static {
        try {
            threadPoolsC = Class.forName(CLASSNAME_THREADPOOLS);
            executeOnceIncludeRequestContextM = threadPoolsC.getMethod("executeOnceIncludeRequestContext", String.class, Runnable.class);
            executeOnceIncludeRequestContextM.setAccessible(true);
        }
        catch (Exception e) {
            logger.error("init kd.bos.threads.ThreadPools error:", (Throwable)e);
        }
    }
}

