/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.dispatch.mservice;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.pigeon.PigeonConsumerManager;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.store.db.StoreDbConfigFactory;
import kd.bos.pigeon.core.store.db.helper.QueueMessageEntityHelper;
import kd.bos.pigeon.core.support.MessageStatus;
import kd.bos.pigeon.dispatch.mservice.DispatchMServiceResponse;
import kd.bos.pigeon.dispatch.mservice.DispatchTaskDTOWrapper;
import kd.bos.pigeon.dispatch.mservice.HashQueue;
import kd.bos.pigeon.dispatch.support.DispatchTaskResultVO;
import kd.bos.pigeon.dispatch.tranformation.dto.DispatchTaskDTO;

public class DispatchService {
    private static final Log LOGGER = LogFactory.getLog(DispatchService.class);
    private String bizType;
    private HashQueue<String, DispatchTaskDTOWrapper> taskQueue;

    public DispatchService(String bizType, HashQueue<String, DispatchTaskDTOWrapper> taskQueue) {
        this.bizType = bizType;
        this.taskQueue = taskQueue;
    }

    public DispatchMServiceResponse dispatch(List<DispatchTaskDTO<?>> dispatchTaskDTOList, List<Integer> indexList, int cacheQueueSize) {
        DispatchMServiceResponse response = new DispatchMServiceResponse();
        try {
            RequestContext requestContext = RequestContext.get();
            boolean isCacheQueueSizeMatch = true;
            ArrayList<Long> idList = new ArrayList<Long>(dispatchTaskDTOList.size());
            ArrayList<DispatchTaskDTOWrapper> receivedDTOList = new ArrayList<DispatchTaskDTOWrapper>(dispatchTaskDTOList.size());
            ArrayList<Integer> receivedIndexList = new ArrayList<Integer>(dispatchTaskDTOList.size());
            ArrayList<Integer> rejectIndexList = new ArrayList<Integer>(dispatchTaskDTOList.size());
            ArrayList<DispatchTaskResultVO.DispatchTaskFailTranformation> rejectReasonList = new ArrayList<DispatchTaskResultVO.DispatchTaskFailTranformation>(dispatchTaskDTOList.size());
            for (int index = 0; index < dispatchTaskDTOList.size(); ++index) {
                DispatchTaskDTO<?> tempTaskDTO = dispatchTaskDTOList.get(index);
                String tempQueueName = tempTaskDTO.getQueueName();
                AtomicInteger tempWaiting = PigeonConsumerManager.getWaiting((String)tempQueueName);
                if (tempWaiting == null) {
                    LOGGER.info("consumer for {} is stop", (Object)tempQueueName);
                    isCacheQueueSizeMatch = false;
                    rejectIndexList.add(indexList.get(index));
                    rejectReasonList.add(DispatchTaskResultVO.DispatchTaskFailTranformation.ROUTE_NOCONSUMER);
                    continue;
                }
                if (tempWaiting.get() < 1) {
                    rejectIndexList.add(indexList.get(index));
                    rejectReasonList.add(DispatchTaskResultVO.DispatchTaskFailTranformation.RPC_OVERCONCURRENCY);
                    continue;
                }
                tempWaiting.decrementAndGet();
                receivedIndexList.add(indexList.get(index));
                receivedDTOList.add(new DispatchTaskDTOWrapper(requestContext.getTenantId(), requestContext.getAccountId(), tempTaskDTO));
                idList.add(tempTaskDTO.getId());
            }
            response.setReceivedIndexList(receivedIndexList);
            if (rejectIndexList.size() == 0) {
                response.setAllReceive(true);
            } else {
                response.setRejectIndexList(rejectIndexList);
                response.setRejectReasonList(rejectReasonList);
            }
            try {
                QueueMessageEntityHelper.updateList((IStoreDbConfig)StoreDbConfigFactory.getDbConfigByBizType((String)this.bizType), idList, (String)MessageStatus.RECEIVED.getDesc(), (String[])new String[]{MessageStatus.READY.getDesc(), MessageStatus.RETRY.getDesc()}, (String)Instance.getInstanceId());
            }
            catch (Exception e2) {
                LOGGER.error("updateList error", (Throwable)e2);
                receivedDTOList.forEach(dto -> {
                    String tempQueueName = dto.getTaskDTO().getQueueName();
                    AtomicInteger tempWaiting = PigeonConsumerManager.getWaiting((String)tempQueueName);
                    tempWaiting.incrementAndGet();
                });
                response.setAllReceive(false);
                response.setReceivedIndexList(new ArrayList<Integer>());
                ArrayList<Integer> dbErrorRejectIndexList = new ArrayList<Integer>(dispatchTaskDTOList.size());
                ArrayList<DispatchTaskResultVO.DispatchTaskFailTranformation> dbErrorRejectReasonList = new ArrayList<DispatchTaskResultVO.DispatchTaskFailTranformation>(dispatchTaskDTOList.size());
                for (int index = 0; index < dispatchTaskDTOList.size(); ++index) {
                    dbErrorRejectIndexList.add(indexList.get(index));
                    dbErrorRejectReasonList.add(DispatchTaskResultVO.DispatchTaskFailTranformation.RPC_OVERCONCURRENCY);
                }
                response.setRejectIndexList(dbErrorRejectIndexList);
                response.setRejectReasonList(dbErrorRejectReasonList);
                response.setTaskQueueSize(this.taskQueue.size());
                response.setCacheQueueSizeMatch(isCacheQueueSizeMatch && cacheQueueSize == PigeonConsumerManager.getQueueNameSet().size());
                return response;
            }
            receivedDTOList.forEach(e -> {
                try {
                    this.taskQueue.put(e.getTaskDTO().getQueueName(), (DispatchTaskDTOWrapper)e);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            response.setTaskQueueSize(this.taskQueue.size());
            response.setCacheQueueSizeMatch(isCacheQueueSizeMatch && cacheQueueSize == PigeonConsumerManager.getQueueNameSet().size());
        }
        catch (Exception e3) {
            LOGGER.error("dispatch error", (Throwable)e3);
        }
        return response;
    }
}

