/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.dispatch.mservice;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

class HashQueue<K, V> {
    final ReentrantLock lock;
    private final List<List<V>> q;
    private final Condition notEmpty;
    private final Condition notFull;
    private static final int SHARD_SIZE = 8;
    private final int capacity;
    private final AtomicInteger count = new AtomicInteger();
    private volatile int takeShard = 0;

    public HashQueue(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.q = new ArrayList<List<V>>(8);
        for (int i = 0; i < 8; ++i) {
            this.q.add(new LinkedList());
        }
        this.lock = new ReentrantLock(false);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
    }

    private int findTargetShard(K k) {
        return Math.abs(k.hashCode() % 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(K k, V e) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.count.get() == this.capacity) {
                boolean bl = false;
                return bl;
            }
            this.enqueue(k, e);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K k, V e) throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            while (this.count.get() >= this.capacity) {
                this.notFull.await();
            }
            this.enqueue(k, e);
        }
        finally {
            lock.unlock();
        }
    }

    private void enqueue(K k, V e) {
        int target = this.findTargetShard(k);
        this.q.get(target).add(e);
        this.count.incrementAndGet();
        this.notEmpty.signal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirst(K k, V e) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int target = this.findTargetShard(k);
            this.q.get(target).add(0, e);
            this.count.incrementAndGet();
            this.notEmpty.signal();
        }
        finally {
            lock.unlock();
        }
    }

    public V take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.count.get() == 0) {
                this.notEmpty.await();
            }
            V v = this.dequeue();
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    private V dequeue() {
        int takeShard = this.takeShard;
        while (this.q.get(takeShard).isEmpty()) {
            if (++takeShard >= 8) {
                takeShard = 0;
            }
            if (takeShard != this.takeShard) continue;
        }
        if (this.q.get(takeShard).isEmpty()) {
            return null;
        }
        V x = this.q.get(takeShard).remove(0);
        if (++takeShard >= 8) {
            takeShard = 0;
        }
        this.takeShard = takeShard;
        this.count.decrementAndGet();
        this.notFull.signal();
        return x;
    }

    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.count.get();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveMatchToEnd(K k, Predicate<V> filter) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int target = this.findTargetShard(k);
            List<V> list = this.q.get(target);
            ArrayList<V> unMatchList = new ArrayList<V>();
            Iterator<V> each = list.iterator();
            while (each.hasNext()) {
                V v = each.next();
                if (filter.test(v)) continue;
                unMatchList.add(v);
                each.remove();
            }
            if (!unMatchList.isEmpty()) {
                list.addAll(0, unMatchList);
            }
        }
        finally {
            lock.unlock();
        }
    }
}

